### Name: RangedData-methods
### Title: Data on a Genome
### Aliases: RangedData-methods GenomicData score<-
###   score<-,RangedData-method score,RangedData-method chrom
###   chrom,RangedData-method genome genome,RangedData-method genome<-
###   genome<-,RangedData-method strand,RangedData-method
### Keywords: classes methods

### ** Examples

  range1 <- IRanges(start=c(1,2,3), end=c(5,2,8))

  ## just ranges
  gr <- GenomicData(range1) 

  ## with a genome (universe)
  gr <- GenomicData(range1, genome = "hg18")
  genome(gr) ## "hg18"

  ## with some data
  filter <- c(1L, 0L, 1L)
  score <- c(10L, 2L, NA)
  strand <- factor(c("+", NA, "-"), levels = levels(strand()))
  gr <- GenomicData(range1, score, genome = "hg18")
  gr[["score"]]
  strand(gr) ## all NA
  gr <- GenomicData(range1, score, filt = filter, strand = strand)
  gr[["filt"]]
  strand(gr) ## equal to 'strand'

  range2 <- IRanges(start=c(15,45,20,1), end=c(15,100,80,5))
  ranges <- c(range1, range2)
  score <- c(score, c(0L, 3L, NA, 22L)) 
  chrom <- paste("chr", rep(c(1,2), c(length(range1), length(range2))), sep="")
  
  gr <- GenomicData(ranges, score, chrom = chrom, genome = "hg18")
  chrom(gr) # equal to 'chrom'
  gr[["score"]] # unlists over the chromosomes
  score(gr)
  gr[1][["score"]] # equal to score[1:3]



