### Name: SBMLDocument-class
### Title: "SBMLDocument" from libsbml
### Aliases: SBMLDocument-class coerce,SBMLDocument,graph-method
###   coerce,SBMLDocument,SBML-method rsbml_check,SBMLDocument-method
###   rsbml_check rsbml_dom,SBMLDocument-method rsbml_dom
###   rsbml_graph,SBMLDocument-method rsbml_graph
###   rsbml_problems,SBMLDocument-method rsbml_problems
###   rsbml_write,SBMLDocument-method rsbml_xml,SBMLDocument-method
###   as.character.SBMLDocument simulate,SBMLDocument-method
### Keywords: classes

### ** Examples

  # Read a document into an R DOM
  dom <- rsbml_read(system.file("sbml", "GlycolysisLayout.xml", package
= "rsbml"))
  
  # Convert to a graph
  graph <- rsbml_graph(dom)
  
  # Write it out to a file
  ## Not run: rsbml_write(dom, "my.xml")
  
  # Or convert it to a string of XML
  rsbml_xml(dom)

  # Read into external libsbml data structure
  doc <- rsbml_read(system.file("sbml", "GlycolysisLayout.xml", package
= "rsbml"), dom = FALSE)
  
  # Convert it explicitly to an S4 DOM
  dom <- rsbml_dom(doc)



