training.nl              package:rHVDM              R Documentation

_P_e_r_f_o_r_m_s _t_h_e _H_V_D_M _t_r_a_i_n_i_n_g _s_t_e_p _a_n_d _r_e_t_u_r_n_s _a _l_i_s_t _c_o_n_t_a_i_n_i_n_g _t_h_e _r_e_s_u_l_t_s

_D_e_s_c_r_i_p_t_i_o_n:

     This method performs the nonlinear training step of the HVDM
     algorithm. It returns a list that will then be used in the
     subsequent screening step.

_U_s_a_g_e:

     training.nl(inputHVDM,transforms,constraints,forcetransforms,genemodels,firstguess)

_A_r_g_u_m_e_n_t_s:

inputHVDM: an HVDM training object 

transforms: a vector containing the kinetic parameter identifiers that
          have to be transformed during optimisation (optional) 

constraints: "known" values for the activator signal 

forcetransforms: Boolean, whether the transformation in argument
          transforms have to be applied 

genemodels: the type of model that has to be used for each gene

firstguess: a first guess for all the parameters

_D_e_t_a_i_l_s:

     Contrary to the linear training function (without .nl suffix),
     this function takes as main input another training object (either
     a linear training object or a non-linear one, where all the genes
     have been fitted witha MIchelis-Menten model ("MM").

     An exponential transform is set by default for the basal (Bj) and
     degradation (Dj) rates, as well as for the kinetic parameters (Vj
     and Kj) in the production function (through the transforms
     argument). This forces the values for these parameters to be
     positive For the exponent Nj, the 'expp1' function ensures it is
     greater than one, when the hill formulation is used. To turn this
     off, set the 'forcetransforms' switch to FALSE. Even in this case
     the degradation rate will not be allowed to take non-positive
     values as it causes problems with the differential operator used
     internally. The value in the vector indicates the parameter to be
     transformed: "Bj": basal rate of transcription, "Sj": sensitivity,
     "Dj": degrdation rate, etc.. The entry label indicates the
     transform to be applied.

     The 'constraints' argument is used to specify values for know
     values of some of the parameters, typically the strength of the
     activator for some time points. See example below for the syntax.

     The 'genemodels' argument is compulsory and used to specify the
     model used for each individual gene. MM means Michaelis-Menten
     model whereas hill means a hill function is used. The general form
     of the production function is 'Bj+Vj*f(t)^Nj/(Kj^Nj+f(t)^Nj)'
     where Nj=1 for the MM model and Nj>1 in the hill case. See below
     for the syntax of the input.

     The 'firstguess' argument is not in use yet and will offer the
     possibility to enter a first guess for the fitting.

_V_a_l_u_e:

     a list containing the results.

_A_u_t_h_o_r(_s):

     Martino Barenco

_R_e_f_e_r_e_n_c_e_s:

     M. Barenco, D. Tomescu, D. Brewer, R. Callard, J. Stark, M. Hubank
     (2006) Ranked predictions of p53 targets using Hidden Variable
     Dynamic Modelling. _Genome Biology_, *V7(3)*, R25.

_S_e_e _A_l_s_o:

     'HVDMcheck','screening.nl','fitgene','HVDMreport','training'

_E_x_a_m_p_l_e_s:

     #load data and fit a linear model
     data(HVDMexample)
     rm(fiveGyMAS5)
     data(HVDMexample2)
     tp532<-training(eset=twodosesMAS5,genes=p53traingenes,degrate=0.8)
     #formulate constraints
     CONSTRAINTS<-c(350,35)
     names(CONSTRAINTS)<-c("trfact1.5Gy.1.4","trfact1.hGy.1.4")
     #specify individual gene models
     GENEMODELS<-rep("MM",5)
     GENEMODELS[c(1,3)]<-"hill"
     names(GENEMODELS)<-p53traingenes
     #run the model
     tp53hyb<-training.nl(inputHVDM=tp532,constraints=CONSTRAINTS,genemodels=GENEMODELS)

