### Encoding: latin1

### Name: KEstimateFast
### Title: Estimate best number of Components for missing value estimation
### Aliases: kEstimateFast
### Keywords: multivariate

### ** Examples

## Load a sample metabolite dataset with 5% missing values (metaboliteData)
data(metaboliteData)

# Estimate best number of PCs with ppca for component 2:4
esti <- kEstimateFast(t(metaboliteData), method = "ppca", evalPcs = 2:4, em="nrmsep")

# Plot the result
barplot(drop(esti$eError), xlab = "Components",ylab = "NRMSEP (1 iterations)")

# The best k value is:
print(esti$minNPcs)



