### Encoding: latin1

### Name: KEstimate
### Title: Estimate best number of Components for missing value estimation
### Aliases: kEstimate
### Keywords: multivariate

### ** Examples

## Load a sample metabolite dataset with 5% missing values (metaboliteData)
data(metaboliteData)

# Do cross validation with ppca for component 2:4
esti <- kEstimate(metaboliteData, method = "ppca", evalPcs = 2:4, nruncv=1, em="nrmsep")

# Plot the average NRMSEP
barplot(drop(esti$eError), xlab = "Components",ylab = "NRMSEP (1 iterations)")

# The best result was obtained for this number of PCs:
print(esti$bestNPcs)

# Now have a look at the variable wise estimation error
barplot(drop(esti$variableWiseError[, which(esti$evalPcs == esti$bestNPcs)]), 
        xlab = "Incomplete variable Index", ylab = "NRMSEP")




