### Name: namedSparse-class
### Title: Class "namedSparse" adds margin names to sparse matrices
### Aliases: namedSparse-class colSums colSumsSp rowSums nsparse
###   Arith,namedSparse,namedSparse-method [,namedSparse-method
###   %*%,namedSparse,namedSparse-method +,namedSparse,namedSparse-method
###   as.matrix,namedSparse-method
###   colSums,namedSparse,missing,missing-method
###   dimnames,namedSparse-method dimnames<-,namedSparse,list-method
###   mat,namedSparse-method maxval,matrix.csr-method
###   ncol,namedSparse-method nrow,namedSparse-method
###   rowSums,namedSparse,missing,missing-method show,namedSparse-method
###   t,namedSparse-method %+% AMN as.matrix.ok exns2 makeNamedSparse
###   makeSparseZero mapNamesInds mat maxval mkNS rowSumsSp sumSp sumSpSLOW
###   colinds,namedSparse,character-method
###   rowinds,namedSparse,character-method rowinds colinds
### Keywords: classes

### ** Examples

data(A.csr)
namedA <- mkNS(A.csr) # installs default dimnames R{1:nrow}, C{1:ncol}
print(namedA)
print(colSums(namedA))
dimnames(namedA) <- list(paste("A",1:10,sep=""),paste("B",1:5,sep=""))
print(namedA)
print(namedA %*% t(namedA))



