### Name: corr.null
### Title: Function to estimate a test statistics joint null distribution
###   for t-statistics via the vector influence curve
### Aliases: corr.null tQuantTrans
### Keywords: htest internal

### ** Examples

set.seed(99)
data <- matrix(rnorm(10*50),nr=10,nc=50)
nulldistn.mvrnorm <- corr.null(data,t="t.onesamp",alternative="greater",B=5000)
nulldistn.chol <- corr.null(data,t="t.onesamp",MVN.method="Cholesky",penalty=1e-9)
nulldistn.t <- corr.null(data,t="t.onesamp",ic.quant.trans=TRUE)
dim(nulldistn.mvrnorm)




