### Name: kmeansM
### Title: Function to do k-means cluster analysis
### Aliases: kmeansM
### Keywords: hplot

### ** Examples

## Loading the dataset
data(gastro)

## Doing a K-means cluster with 2 groups using all genes, for maigesRaw class
kmeansM(gastro.raw, rmGenes=c("BLANK","DAP","LYS","PHE", "Q_GENE","THR","TRP"),
        sLabelID="Sample", gLabelID="Name", centers=2)

## The same as above, but for maigesNorm class
kmeansM(gastro.norm, rmGenes=c("BLANK","DAP","LYS","PHE", "Q_GENE","THR","TRP"),
        sLabelID="Sample", gLabelID="Name", centers=2)

## Another example with 3 groups
kmeansM(gastro.norm, rmGenes=c("BLANK","DAP","LYS","PHE", "Q_GENE","THR","TRP"),
        sLabelID="Sample", gLabelID="Name", centers=3)

## If you want to use euclidean distance to group genes (or spots) with
## 4 groups
kmeansM(gastro.summ, rmGenes=c("BLANK","DAP","LYS","PHE", "Q_GENE","THR","TRP"),
        sLabelID="Sample", gLabelID="Name", centers=4, group="R", distance="euclidean")



