### Name: classifyKNNsc
### Title: Function to do discrimination analysis, by the search and choose
###   method
### Aliases: classifyKNNsc
### Keywords: methods

### ** Examples

## Loading the dataset
data(gastro)

## Doing KNN classifier with 2 genes for the 6th gene group comparing
## the 2 categories from 'Type' sample label.
gastro.class = classifyKNNsc(gastro.summ, sLabelID="Type",
  gNameID="GeneName", nGenes=2, geneGrp=1, cliques=10)
gastro.class

## To do classifier with 3 genes for the 6th gene group comparing
## normal vs adenocarcinomas from 'Tissue' sample label
gastro.class = classifyKNNsc(gastro.summ, sLabelID="Tissue",
  gNameID="GeneName", nGenes=3, geneGrp=1, cliques=10,
  facToClass=list(Norm=c("Neso","Nest"), Ade=c("Aeso","Aest")))



