### Name: read.madata
### Title: Read Microarray data
### Aliases: read.madata
### Keywords: IO

### ** Examples

# note that .CEL files are not distributed with the package, thus following
# code does not work. This shows how to read data from affy (or beadarray)
# package, when TAB delimited design file is ready.

## Not run: 
##D library(affy)
##D beforeRma <- ReadAffy()
##D rmaData <- rma(beforeRma)
##D datafile <- exprs(rmaData)
##D abf1 <- read.madata(datafile=datafile,designfile="design.txt")
##D 
##D # make and read designfile (data.frame type R object) from R
##D design.table <- data.frame(Array=row.names(pData(beforeRma)));
##D Strain <- rep(c('Aj', 'B6', 'B6xAJ'), each=6)
##D Sample <- rep(c(1:9), each=2)
##D designfile <- cbind(design.table, Strain, Sample)
##D abf1 <- read.madata(datafile, designfile=designfile)
##D 
##D # read in a TAB delimited file with spot flag - for two color array
##D # HAVE TO SPECIFY that the data is from two color array
##D  kidney.raw <- read.madata("kidney.txt", designfile="kidneydesign.txt", 
##D         metarow=1, metacol=2, col=3, row=4, probeid=6,
##D         intensity=7, arrayType='twoColor',log.trans=T, spotflag=T)
## End(Not run)


