###################################################
### chunk number 1: requiredFiles1
###################################################
options(width=60, warn=0, digits=5)
require(goProfiles)


###################################################
### chunk number 2: prostateIds
###################################################
require(goProfiles)
data(prostateIds)


###################################################
### chunk number 3: basicProfilesMF
###################################################
welsh.MF <- basicProfile (welsh01EntrezIDs, onto="MF", level=2, orgPackage="org.Hs.eg.db") 
singh.MF <- basicProfile (singh01EntrezIDs, onto="MF", level=2, orgPackage="org.Hs.eg.db") 
welsh.singh.MF <-mergeProfilesLists(welsh.MF, singh.MF, profNames=c("Welsh", "Singh"))
printProfiles(welsh.singh.MF, percentage=TRUE)


###################################################
### chunk number 4: plotProfileMF
###################################################
plotProfiles (welsh.MF, aTitle="Welsh (2001). Prostate cancer data")


###################################################
### chunk number 5: basicProfilesANY
###################################################
welsh <- basicProfile (welsh01EntrezIDs, onto="ANY", level=2, orgPackage="org.Hs.eg.db") 


###################################################
### chunk number 6: comparevisual
###################################################
plotProfiles (welsh.singh.MF, percentage=T,aTitle="Welsh vs Singh", legend=T) 


###################################################
### chunk number 7: compareDiff1
###################################################
compared.welsh.singh.01.MF <- compareGeneLists (welsh01EntrezIDs, singh01EntrezIDs, onto="MF", level=2, orgPackage="org.Hs.eg.db")
print(compSummary(compared.welsh.singh.01.MF))


###################################################
### chunk number 8: compareEquiv1
###################################################
eqws01<-equivalentGOProfiles(compared.welsh.singh.01.MF, simplify=FALSE)
print(es<-equivSummary(eqws01))


