### Name: globaltest
### Title: Global Test
### Aliases: globaltest
### Keywords: htest

### ** Examples

    # Breast cancer data (ExpressionSet) from the Netherlands Cancer
    # Institute with annotation:
    data(vandeVijver)
    data(annotation.vandeVijver)

    # Many possible calls. See the vignette for more examples and explanation.
    globaltest(vandeVijver, "StGallen")
    globaltest(vandeVijver, "StGallen", annotation.vandeVijver)
    globaltest(vandeVijver, "Surv(TIMEsurvival, EVENTdeath)", annotation.vandeVijver)
    globaltest(vandeVijver, StGallen ~ Posnodes + StGallen, annotation.vandeVijver)
    globaltest(vandeVijver, "StGallen", method = "p")

    # Store the test result
    # See help(gt.result) for more options
    gt <- globaltest(vandeVijver, "StGallen", annotation.vandeVijver)
    gt[1:2]
    sort(gt)
    p.value(gt)

    # Also with simple vector/matrix input
    X <- matrix(rnorm(3000), 100, 30)  # random expression data
    Y <- 1:30                          # a response variable
    pathway <- 1:40                    # a pathway

    globaltest(X, Y)
    globaltest(X, Y, pathway)



