/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.gaggle.experiment.metadata;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.systemsbiology.gaggle.experiment.metadata.Condition;
import org.systemsbiology.gaggle.experiment.metadata.DataSetDescription;
import org.systemsbiology.gaggle.experiment.metadata.Variable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetaData
implements Serializable {
    String title;
    String date;
    String uri;
    HashMap predicates;
    HashMap links;
    ArrayList dataSetDescriptions;
    ArrayList conditions;
    List<Variable> constants;
    List<String> treePaths;
    HashMap variableSummary;
    HashMap selectionCriteria;

    public MetaData(String title, String date) {
        this.title = title;
        this.date = date;
        this.uri = null;
        this.predicates = new HashMap();
        this.links = new HashMap();
        this.dataSetDescriptions = new ArrayList();
        this.conditions = new ArrayList();
        this.variableSummary = new HashMap();
        this.selectionCriteria = new HashMap();
        this.constants = new ArrayList<Variable>();
    }

    public MetaData(String title) {
        this(title, null);
    }

    public String[] getReferenceUrls() {
        return new String[]{"http://www.sewardpark.net"};
    }

    public String getTitle() {
        return this.title;
    }

    public String getDate() {
        return this.date;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public String getUri() {
        return this.uri;
    }

    public String getSpecies() {
        String[] preds = this.getPredicateNamesSorted();
        String result = this.getPredicate("species");
        if (result == null) {
            return "unknown";
        }
        return result;
    }

    public List<Variable> getConstants() {
        return this.constants;
    }

    public void setConstants(List<Variable> constants) {
        this.constants = constants;
    }

    public void setPredicates(HashMap newPredicates) {
        this.predicates = newPredicates;
    }

    public HashMap getPredicates() {
        return this.predicates;
    }

    public String[] getPredicateNamesSorted() {
        Object[] result = this.predicates.keySet().toArray(new String[0]);
        Arrays.sort(result);
        return result;
    }

    public String getPredicate(String name) {
        if (this.predicates.containsKey(name)) {
            return (String)this.predicates.get(name);
        }
        return null;
    }

    public void setDataSetDescriptions(ArrayList newValues) {
        this.dataSetDescriptions = newValues;
    }

    public String getUriBase() {
        int lastSeparator = Math.max(this.uri.lastIndexOf(File.separator), this.uri.lastIndexOf("/"));
        if (lastSeparator > 0) {
            return this.uri.substring(0, lastSeparator + 1);
        }
        return "";
    }

    private DataSetDescription[] absolutizeDataSetUris(DataSetDescription[] dsds) {
        if (this.uri == null || this.uri.length() == 0) {
            return dsds;
        }
        for (int i = 0; i < dsds.length; ++i) {
            String uri = dsds[i].getUri().trim();
            boolean hasProtocol = uri.indexOf("://") > 0;
            char firstChar = uri.charAt(0);
            if (hasProtocol || !Character.isLetterOrDigit(firstChar)) continue;
            String newUri = this.getUriBase() + uri;
            dsds[i].setUri(newUri);
        }
        return dsds;
    }

    public DataSetDescription[] getRawDataSetDescriptions() {
        return this.dataSetDescriptions.toArray(new DataSetDescription[0]);
    }

    public DataSetDescription[] getDataSetDescriptions() {
        return this.absolutizeDataSetUris(this.getRawDataSetDescriptions());
    }

    public HashMap getVariableSummary() {
        return this.variableSummary;
    }

    public void addLink(String type, String url) {
        this.links.put(type, url);
    }

    public HashMap getReferenceLinks() {
        return this.links;
    }

    public void addCondition(Condition condition) {
        this.conditions.add(condition);
        this.updateVariableSummary(condition);
    }

    protected void updateVariableSummary(Condition condition) {
        String[] variableNames = condition.getVariableNames();
        for (int i = 0; i < variableNames.length; ++i) {
            Variable variable = condition.getVariable(variableNames[i]);
            String name = variable.getName();
            String value = variable.getValue();
            String units = variable.getUnits();
            HashMap variableDescription = !this.variableSummary.containsKey(name) ? new HashMap() : (HashMap)this.variableSummary.get(name);
            if (!variableDescription.containsKey(value)) {
                variableDescription.put(value, units);
            }
            this.variableSummary.put(name, variableDescription);
        }
    }

    public Condition[] getConditions() {
        return this.conditions.toArray(new Condition[0]);
    }

    public boolean hasCondition(String alias) {
        Condition[] conditions = this.getConditions();
        for (int c = 0; c < conditions.length; ++c) {
            if (!conditions[c].getAlias().equalsIgnoreCase(alias)) continue;
            return true;
        }
        return false;
    }

    public Condition getCondition(String alias) {
        Condition[] conditions = this.getConditions();
        for (int i = 0; i < conditions.length; ++i) {
            if (!conditions[i].getAlias().equalsIgnoreCase(alias)) continue;
            return conditions[i];
        }
        return null;
    }

    public String[] getVariableNames() {
        return this.variableSummary.keySet().toArray(new String[0]);
    }

    public HashMap getVariableValuesWithUnits(String variableName) {
        if (!this.variableSummary.containsKey(variableName)) {
            return null;
        }
        return (HashMap)this.variableSummary.get(variableName);
    }

    public String getUnits(String variableName, String variableValue) {
        if (!this.variableSummary.containsKey(variableName)) {
            return null;
        }
        HashMap oneVariable = (HashMap)this.variableSummary.get(variableName);
        if (!oneVariable.containsKey(variableValue)) {
            return null;
        }
        return (String)oneVariable.get(variableValue);
    }

    public String[] getSortedVariableValues(String variableName) {
        if (!this.variableSummary.containsKey(variableName)) {
            return new String[0];
        }
        HashMap valuesWithUnits = this.getVariableValuesWithUnits(variableName);
        if (valuesWithUnits == null) {
            return new String[0];
        }
        Object[] values = valuesWithUnits.keySet().toArray(new String[0]);
        Arrays.sort(values);
        return values;
    }

    public String[] getNamesOfSelectedVariables() {
        Object[] result = this.selectionCriteria.keySet().toArray(new String[0]);
        Arrays.sort(result);
        return result;
    }

    public boolean columnSelected(Condition condition, HashMap selectionCriteria) {
        boolean result = true;
        String[] selectedVariables = this.getNamesOfSelectedVariables();
        Variable[] conditionVariables = condition.getVariables();
        boolean atLeastOneExactMatchFound = false;
        boolean atLeastOneContradictionFound = false;
        for (int cv = 0; cv < conditionVariables.length; ++cv) {
            ArrayList selectedValues;
            Variable variable = conditionVariables[cv];
            String varName = variable.getName();
            String varValue = variable.getValue();
            if (!selectionCriteria.containsKey(varName) || (selectedValues = (ArrayList)selectionCriteria.get(varName)).size() == 0) continue;
            if (selectedValues.contains(varValue)) {
                atLeastOneExactMatchFound = true;
                continue;
            }
            atLeastOneContradictionFound = true;
        }
        return atLeastOneExactMatchFound && !atLeastOneContradictionFound;
    }

    public Condition[] getSelectedConditions() {
        if (this.selectionCriteria.size() == 0) {
            return new Condition[0];
        }
        ArrayList<Condition> result = new ArrayList<Condition>();
        for (int i = 0; i < this.conditions.size(); ++i) {
            Condition condition = (Condition)this.conditions.get(i);
            if (!this.columnSelected(condition, this.selectionCriteria)) continue;
            result.add(condition);
        }
        return result.toArray(new Condition[0]);
    }

    public String[] getSelectedConditionsAsAliases() {
        Condition[] conditions = this.getSelectedConditions();
        Object[] result = new String[conditions.length];
        for (int c = 0; c < conditions.length; ++c) {
            result[c] = conditions[c].getAlias();
        }
        Arrays.sort(result);
        return result;
    }

    public void clearSelectionCriteria() {
        this.selectionCriteria = new HashMap();
    }

    public HashMap getSelectionCriteria() {
        return this.selectionCriteria;
    }

    public void selectConditionByName(String conditionName) {
        HashMap variableValuesHash = this.getVariableValuesWithUnits(conditionName);
        if (variableValuesHash == null) {
            return;
        }
        String[] variableValues = variableValuesHash.keySet().toArray(new String[0]);
        for (int v = 0; v < variableValues.length; ++v) {
            this.addSelectionCriterion(conditionName, variableValues[v]);
        }
    }

    public void selectAllConditions() {
        String[] variableNames = this.getVariableNames();
        for (int v = 0; v < variableNames.length; ++v) {
            HashMap varValueCluster = this.getVariableValuesWithUnits(variableNames[v]);
            if (varValueCluster == null) continue;
            String[] varValueNames = varValueCluster.keySet().toArray(new String[0]);
            for (int i = 0; i < varValueNames.length; ++i) {
                this.addSelectionCriterion(variableNames[v], varValueNames[i]);
            }
        }
    }

    public void addSelectionCriterion(String variableName, String variableValue) {
        if (!this.variableSummary.containsKey(variableName)) {
            return;
        }
        HashMap hash = (HashMap)this.variableSummary.get(variableName);
        if (!((HashMap)this.variableSummary.get(variableName)).containsKey(variableValue)) {
            return;
        }
        ArrayList list = new ArrayList();
        if (this.selectionCriteria.containsKey(variableName)) {
            list = (ArrayList)this.selectionCriteria.get(variableName);
        }
        list.add(variableValue);
        this.selectionCriteria.put(variableName, list);
    }

    public void setConditions(ArrayList newValue) {
        this.conditions = newValue;
    }

    public String[] getConditionAliases() {
        ArrayList<String> list = new ArrayList<String>();
        Condition[] conditions = this.getConditions();
        for (int i = 0; i < conditions.length; ++i) {
            list.add(conditions[i].getAlias());
        }
        return list.toArray(new String[0]);
    }

    public List<String> getTreePaths() {
        return this.treePaths;
    }

    public void setTreePaths(List<String> treePaths) {
        this.treePaths = treePaths;
    }

    public String toString() {
        int i;
        StringBuffer sb = new StringBuffer();
        sb.append("title: ");
        sb.append(this.title);
        sb.append("\n");
        if (this.uri != null) {
            sb.append("uri: ").append(this.uri).append("\n");
        }
        sb.append("datasets: ");
        DataSetDescription[] ds = this.getDataSetDescriptions();
        for (int i2 = 0; i2 < ds.length; ++i2) {
            sb.append(ds[i2].toString());
            sb.append("\n");
        }
        sb.append("\n");
        sb.append("predicates: ");
        String[] keys = this.predicates.keySet().toArray(new String[0]);
        for (i = 0; i < keys.length; ++i) {
            sb.append(keys[i]);
            sb.append(" = ").append(this.predicates.get(keys[i]));
            sb.append("\n");
        }
        sb.append("variableDefinitions: ");
        sb.append(this.getVariableSummary());
        sb.append("\n");
        sb.append("conditions: ");
        for (i = 0; i < this.conditions.size(); ++i) {
            sb.append(this.getConditions()[i].toString());
            sb.append("\n");
        }
        return sb.toString();
    }
}

