###################################################
### chunk number 1: 
###################################################
library(flowCore);
library(XML);
library(flowFlowJo);
demoLocation <- system.file("extdata", "DemoWorkspace.wsp", package="flowFlowJo");
actualFCSLoc <- system.file("extdata/fcsFiles", package="flowFlowJo");
testList <- readFlowJoList(demoLocation, altFileLocation=actualFCSLoc);


###################################################
### chunk number 2: 
###################################################
z <- getFlowJoGates(testList, fileNamePatterns=c("C02"));
print(summary(z));
print(summary(z$filter));


###################################################
### chunk number 3: 
###################################################
getFlowJoSummary(testList, gatesByFile=FALSE, removeParentalNames=TRUE); 
getFlowJoSummary(testList, removeParentalNames=TRUE);


###################################################
### chunk number 4: 
###################################################
summaryStatsObj <- collectSummaryFlowInfo(testList);


###################################################
### chunk number 5: 
###################################################
expDescFrame <- data.frame(Drug=c(rep("Amospho", 3), 
                                  rep("Gleevec", 3), 
                                  rep("Chloro", 3)), 
   Conc=rep(c(0.001, 0.0001, 0.00001), 3), 
   FCSFilename=dir(actualFCSLoc, full.names=TRUE), 
   FlowJoWorkspace=rep(demoLocation, length(dir(actualFCSLoc)))); 


###################################################
### chunk number 6: 
###################################################
flowReport <- createFlowReport(summaryStatsObj,  factorsFrame=expDescFrame);
print(head(flowReport));


