###################################################
### chunk number 1: 
###################################################
library(clusterStab)
library(genefilter)
library(fibroEset)
data(fibroEset)
exprs(fibroEset) <- log2(exprs(fibroEset))
filt <- cv(0.1, Inf)
index <- genefilter(fibroEset, filt)
fb <- fibroEset[index,]
bh <- benhur(fb, 0.7, 6, seednum = 12345) #seednum only used to ensure reproducibility


###################################################
### chunk number 2: 
###################################################
hist(bh)


###################################################
### chunk number 3: 
###################################################
plot(hclust(dist(t(exprs(fibroEset[index,])))), labels = pData(fibroEset)[,2], sub="", xlab="")


###################################################
### chunk number 4: 
###################################################
ecdf(bh)


###################################################
### chunk number 5: 
###################################################
cmp <- clusterComp(fb, 2)
cmp


