### Name: aqm.prepdata
### Title: Generate an object aqmobj.prepdata to be called by the aqm
###   functions.
### Aliases: aqm.prepdata aqm.prepdata,ExpressionSet-method
###   aqm.prepdata,AffyBatch-method aqm.prepdata,NChannelSet-method
###   aqm.prepdata,BeadLevelList-method aqm.prepdata,aqmOneCol-method


### ** Examples

    ## Load an example of a NChannelSet
    library(CCl4)
    data(CCl4)

    ## Normalization of CCl4 using vsn
    library(vsn)
    CCl4norm = justvsn(CCl4, subsample=2000)

    ## Add a column in the phenoData to annotate samples 
    cond = paste(pData(CCl4norm)$RIN.Cy3,pData(CCl4norm)$RIN.Cy5,sep="/")
    poor = grep(cond,pattern="2.5")
    medium = grep(cond,pattern="^5/|/5")
    good = grep(cond,pattern="9.7")
    cov = rep(0, length = nrow(pData(CCl4norm)))
    cov[good] = "Good"
    cov[medium] = "Medium"
    cov[poor] = "Poor"
    phenoData(CCl4norm)$RNAintegrity = cov

    ## Add X and Y columns in the featureData to allow spatial representations
    featureData(CCl4norm)$X = featureData(CCl4norm)$Row
    featureData(CCl4norm)$Y = featureData(CCl4norm)$Column

    ## Add a hasTarget column in the featureData to call aqm.probesmap
    featureData(CCl4norm)$hasTarget = (regexpr("^NM",
                                       featureData(CCl4norm)$Name)> 0)

    ## Prepare the data for aqm.xxx calls
    CCl4prep = aqm.prepdata(CCl4norm, do.logtransform = FALSE)

    ## Draw MA plots
    ma = aqm.maplot(dataprep = CCl4prep)
    class(ma)
    aqm.plot(ma)

    ## Draw heatmap making use of the RNAintegrity
    ## column of the phenoData
    hm = aqm.heatmap(expressionset = CCl4norm,
                     dataprep = CCl4prep,
                     intgroup = "RNAintegrity")
    class(hm)
    aqm.plot(hm)

    ## Draw probes mapping density curves making use of the hasTarget
    ## column of the featureData
    sp = aqm.spatial(expressionset = CCl4norm,
                     dataprep = CCl4prep,
                     scale = "Rank")
    class(sp)
    aqm.plot(sp)

    ## Draw probes mapping density curves making use of the hasTarget
    ## column of the featureData
    pm = aqm.probesmap(expressionset = CCl4norm, dataprep = CCl4prep)
    class(pm)
    aqm.plot(pm)




