###################################################
### chunk number 1: Setup
###################################################
library("Biobase")
library("annotate")
library("xtable")
require("Rgraphviz", quietly=TRUE)
library("hgu95av2.db")
library("GO.db")


###################################################
### chunk number 2: parentrel
###################################################
 GOTERM$"GO:0003700"

 GOMFPARENTS$"GO:0003700"
 GOMFCHILDREN$"GO:0003700"



###################################################
### chunk number 3: locusid
###################################################

 ll1 = hgu95av2GO[["39613_at"]]
 length(ll1)
 sapply(ll1, function(x) x$Ontology)



###################################################
### chunk number 4: getmappings
###################################################

getOntology(ll1, "BP")
getEvidence(ll1)
zz = dropECode(ll1)
getEvidence(zz)



###################################################
### chunk number 5: sizeofonts
###################################################

 zz = eapply(GOTERM, function(x) x@Ontology)
 table(unlist(zz))



###################################################
### chunk number 6: isa-partof
###################################################

 BPisa = eapply(GOBPPARENTS, function(x) names(x))
 table(unlist(BPisa))

 MFisa = eapply(GOMFPARENTS, function(x) names(x))
 table(unlist(MFisa))

 CCisa = eapply(GOCCPARENTS, function(x) names(x))
 table(unlist(CCisa))



###################################################
### chunk number 7: finding these
###################################################
 goterms = unlist(eapply(GOTERM, function(x) x@Term))
 whmf = grep("molecular_function", goterms)


###################################################
### chunk number 8: subsetGT
###################################################
 goterms[whmf]



###################################################
### chunk number 9: getMF
###################################################
affyGO = eapply(hgu95av2GO, getOntology)
table(sapply(affyGO, length))



###################################################
### chunk number 10: getEvidence
###################################################
affyEv = eapply(hgu95av2GO, getEvidence)

table(unlist(affyEv, use.names=FALSE))



###################################################
### chunk number 11: dropOneEvidence
###################################################
test1 = eapply(hgu95av2GO, dropECode, c("IEA", "NR"))

table(unlist(sapply(test1, getEvidence),
             use.names=FALSE))


