### Name: tsLib-class
### Title: Class for representing a reference library
### Aliases: tsLib-class [,tsLib-method $,tsLib-method libId,tsLib-method
###   libId length,tsLib-method libData,tsLib-method libData
###   libName,tsLib-method libName libName<-,tsLib-method libName<-
###   libRI,tsLib-method libRI libRI<-,tsLib-method libRI<-
###   medRI,tsLib-method medRI medRI<-,tsLib-method medRI<-
###   refLib,tsLib-method refLib RIdev,tsLib-method RIdev
###   RIdev<-,tsLib-method RIdev<- selMass,tsLib-method selMass
###   selMass<-,tsLib-method selMass<- show,tsLib-method
###   spectra,tsLib-method spectra spectra<-,tsLib-method spectra<-
###   topMass,tsLib-method topMass topMass<-,tsLib-method topMass<-
### Keywords: classes

### ** Examples

showClass("tsLib")

# define some metabolite names
libNames   <- c("Metab1", "Metab2", "Metab3")
# the expected retention index
RI         <- c(100,200,300)
# selective masses to search for. A list of vectors.
selMasses  <- list(c(95,204,361), c(87,116,190), c(158,201,219))
# define the retention time windows to look for the given selective masses.
RIdev      <- matrix(rep(c(10,5,2), length(libNames)), ncol = 3, byrow = TRUE)
# Set the mass spectra. A list object of two-column matrices, or set to 
# an empty list if the spectra is not available
spectra    <- list()
# some extra information about the library
libData    <- data.frame(Name = libNames, Lib_RI = RI)
# create a reference library object
refLibrary <- new("tsLib", Name = libNames, RI = RI, medRI = RI, RIdev = RIdev,
                        selMass = selMasses, topMass = selMasses, spectra = spectra, libData = libData) 

# get the metabolite names
libName(refLibrary)
# set new names
libName(refLibrary) <- c("Metab01", "Metab02", "Metab03")

# get the expected retention times
libRI(refLibrary)
# set the retention time index for metabolite 3 to 310 seconds
libRI(refLibrary)[3] <- 310
# change the seleccion and top masses of metabolite 3
selMass(refLibrary)[[3]] <- c(158,201,219,220,323)
topMass(refLibrary)[[3]] <- c(158,201,219,220,323)
# change the retention time deviations
RIdev(refLibrary)[3,] <- c(8,4,1)




