### Name: RIcorrect
### Title: Peak picking from CDF files and RI correction
### Aliases: RIcorrect


### ** Examples

require(TargetSearchData)
# import refLibrary, rimLimits and sampleDescription.
data(TargetSearchData)
# get the CDF files
cdfpath <- file.path(.find.package("TargetSearchData"), "gc-ms-data")
cdfpath
list.files(cdfpath)
# update the CDF path
CDFpath(sampleDescription) <- cdfpath
# run RIcorrect (massScanRange = 85-320; Intensity Threshold = 50;
# peak detection method = "ppc", window = 15)
RImatrix <- RIcorrect(sampleDescription, rimLimits, massRange = c(85,320), 
            Window = 15, pp.method = "ppc", IntThreshold = 50)

# you can try other parameters and other peak picking algorithm.
RImatrix <- RIcorrect(sampleDescription, rimLimits, massRange = c(85,320), 
            Window = 15, pp.method = "smoothing", IntThreshold = 10)

RImatrix <- RIcorrect(sampleDescription, rimLimits, massRange = c(85,320), 
            Window = 15, pp.method = "ppc", IntThreshold = 100)




