### Name: srFilter
### Title: Functions for user-created and built-in ShortRead filters
### Aliases: srFilter srFilter,missing-method srFilter,function-method
###   idFilter chromosomeFilter positionFilter strandFilter uniqueFilter
###   nFilter polynFilter dustyFilter srdistanceFilter alignQualityFilter
###   alignDataFilter compose
### Keywords: manip

### ** Examples

sp <- SolexaPath(system.file("extdata", package="ShortRead"))
aln <- readAligned(sp, "s_2_export.txt") # Solexa export file, as example

# a 'chromosome 5' filter
filt <- chromosomeFilter("chr5.fa")
aln[filt(aln)]
# filter during input
readAligned(sp, "s_2_export.txt", filter=filt)

# x- and y- coordinates stored in alignData, when source is SolexaExport
xy <- alignDataFilter(expression(abs(x-500) > 200 & abs(y-500) > 200))
aln[xy(aln)]

# both filters
chr5xy <- compose(filt, xy)
aln[chr5xy(aln)]

# custom filter: minimum calibrated base call quality >20
goodq <- srFilter(function(x) {
    apply(as(quality(x), "matrix"), 1, min) > 20
}, name="GoodQualityBases")
goodq
aln[goodq(aln)]



