### Name: pileup
### Title: Calculate a pile-up representation of short-read mappings
### Aliases: pileup


### ** Examples
## Not run:  
##D 
##D Example 1: Assuming that 'lane' is an 'AlignedRead' object containing
##D aligned reads froma Solexa lane, you may get a pile-up representation of
##D chromosome 13 as follows
##D 
##D chr13length <- 114142980   # the length of human chromosme 13
##D pu <- pileup( position(lane)[chromosome(lane)=="13"], width(lane), chr13length )
##D 
##D Example 2: Even though the width of the reads (as repored by
##D 'width(lane)') is only 24, these 24 bp are just one end of a longer
##D fragment. Assuming that all fragments have been sonicated to about the
##D same length, say 150 bp, we may get a better pile-up representation by:
##D 
##D pu2 <- pileup( position(lane)[chromosome(lane)=="13"], 150, chr13length,
##D strand(lane)[chromosome(lane)=="13"], width(lane) )
##D 
## End(Not run)


