### Name: tabulate.pvals
### Title: Sums significant p-values for the analyzed regions
### Aliases: tabulate.pvals
### Keywords: misc

### ** Examples

#load the datasets and the samples to run the integrated analysis
data(expr.data)
data(acgh.data)
data(samples) 
         
#assemble the data
assemble.data(dep.data = acgh.data, indep.data = expr.data, ann.dep = 1:4,ann.indep = 1:4, dep.id="ID", dep.chr = "CHROMOSOME",dep.pos = "STARTPOS",dep.symb="Symbol", indep.id="ID",indep.chr = "CHROMOSOME", indep.pos = "STARTPOS", indep.symb="Symbol", overwrite = TRUE,run.name = "chr8")

#run the integrated analysis
integrated.analysis(samples = samples, input.regions = 8, adjust = FALSE, zscores=TRUE, method = "auto",run.name = "chr8")

#tabulate the p-values per region
tabulate.pvals(input.regions = 8,adjust.method="BY", bins=c(0.001,0.005,0.01,0.025,0.05,0.075,0.10,0.20,1.0), significance.idx=8, order.by="%", decreasing=TRUE, run.name = "chr8") 




