### Name: makeLaw
### Title: Generate an R function for the reaction rate law
### Aliases: makeLaw
### Keywords: math

### ** Examples

library(SBMLR)  
curto=readSBMLR(file.path(system.file(package="SBMLR"), "models/curto.r"))  
curto$reactions[["ada"]]
e=curto$reactions[["ada"]]$exprLaw;e
r=curto$reactions[["ada"]]$reactants;r
m=curto$reactions[["ada"]]$modifiers;m
r=c(r,m)
p=curto$reactions[["ada"]]$parameters;p
makeLaw(r,p,e)

## compare to 

curto$reactions[["ada"]]$law

## indeed, above is how $law functions are now made, and in part why readSBMLR has replaced source.




