### Name: distribution-methods
### Title: Method for generating the (scaled) probablility distribution
###   induced with a given mutagenetic trees mixture model
### Aliases: distribution distribution-methods
###   distribution,RtreemixModel,missing,missing,missing-method
###   distribution,RtreemixModel,character,numeric,numeric-method
### Keywords: methods distribution

### ** Examples

## Generate a random RtreemixModel object with 3 components.
mod <- generate(K = 3, no.events = 8, noise.tree = TRUE, prob = c(0.2, 0.8))
show(mod)

## See the probability distribution encoded by the model on the set of all possible patterns.
distr <- distribution(model = mod)
distr

## Get the probabilities.
distr$probability

## See the probability distribution encoded by the model on the set of all possible patterns
## calculated for given sampling mode, and corresponding input and output parameters.
distr1 <- distribution(model = mod, sampling.mode = "exponential", sampling.param = 1, output.param = 1)
distr1



