### Name: comp.trees
### Title: Functions for quantifying the diversity of the nontrivial trees
###   in a mutagenetic trees mixture model
### Aliases: comp.trees comp.trees.levels
### Keywords: misc

### ** Examples

## Generate two random RtreemixModel objects each with 3 components.
mix1 <- generate(K = 3, no.events = 9, noise.tree = TRUE, prob = c(0.2, 0.8))
mix2 <- generate(K = 3, no.events = 9, noise.tree = TRUE, prob = c(0.2, 0.8))
## Inspect the diversity of the nontrivial tree components in a given model
## using the number of distinct edges and the levels of the events in
## the treesas dissimilarity measure.
comp.trees.levels(model = mix1)
comp.trees.levels(model = mix2)



