### Name: finalClassifier-class
### Title: finalClassifier: A class to store the final classifier
###   corresponding to an assessment
### Aliases: finalClassifier-class
###   getGenesFromBestToWorst,finalClassifier-method
###   getGenesFromBestToWorst getModels,finalClassifier-method getModels
### Keywords: classes

### ** Examples

#dataPath <- file.path("C:", "Documents and Settings", "c.maumet", "My Documents", "Programmation", "Sources", "SVN", "R package", "data")
#aDataset <- new("dataset", dataId="vantVeer_70", dataPath=dataPath)
#aDataset <- loadData(aDataset)
data('vV70genesDataset')

mySubsets <- new("geneSubsets", optionValues=c(1,2,4,8,16,32,64,70))
expeOfInterest <- new("assessment", dataset=vV70genes,
                               noFolds1stLayer=10,
                               noFolds2ndLayer=9,
                               classifierName="svm",
                               typeFoldCreation="original",
                               svmKernel="linear",
                               noOfRepeat=2,
                               featureSelectionOptions=mySubsets)

expeOfInterest <- findFinalClassifier(expeOfInterest)

# Return the whole object of class finalClassifier
finalClassifier <- getFinalClassifier(expeOfInterest)

# Svm model corresponding to a subset of size 4 (3rd size of subset)
getModels(finalClassifier)[[3]]$model
# Relevant genes for a subset of size 4 (3rd size of subset)
getModels(finalClassifier)[[3]]$modelFeatures

# Genes ordered according to their weight after performing the RFE up to 1 gene
getGenesFromBestToWorst(finalClassifier)




