### Name: twoGaussiansNull
### Title: Estimate a threshold from Gaussian mixture distribution
### Aliases: twoGaussiansNull
### Keywords: manip

### ** Examples

  exDir <- system.file("exData",package="Ringo")
  load(file.path(exDir,"exampleProbeAnno.rda"))
  load(file.path(exDir,"exampleX.rda"))
  smoothX <- computeRunningMedians(exampleX, probeAnno=exProbeAnno,
     modColumn = "Cy5", allChr = "9", winHalfSize = 400)

  ## compare the two different ways of estimating the threshold
  y0a <- apply(exprs(smoothX), 2, upperBoundNull)
  y0b <- apply(exprs(smoothX), 2, twoGaussiansNull)

  hist(exprs(smoothX)[,1], n=10, main=NA,
       xlab="Smoothed expression level [log2]")
  abline(v=c(y0a, y0b), col=c("blue","orange"), lwd=2)
  legend(x="topright", col=c("blue","orange"), lwd=2, 
         legend=c(expression(paste(y[0]," Non-parametric")),
                  expression(paste(y[0]," Gaussian"))))



