### Name: computeRunningMedians
### Title: Function to compute running medians on a tiling expression set
### Aliases: computeRunningMedians
### Keywords: manip

### ** Examples

  exDir <- system.file("exData",package="Ringo")
  load(file.path(exDir,"exampleProbeAnno.rda"))
  load(file.path(exDir,"exampleX.rda"))
  smoothX <- computeRunningMedians(exampleX, probeAnno=exProbeAnno,
modColumn = "Cy5", allChr = c("9"), winHalfSize = 400, verbose = TRUE)
  if (interactive()){
   par(mfrow=c(1,1))
   chipAlongChrom(exampleX, chrom="9", xlim=c(34318000,34321000), ylim=c(-2,4), probeAnno=exProbeAnno, gff=exGFF)
   chipAlongChrom(smoothX, chrom="9", xlim=c(34318000,34321000),
probeAnno=exProbeAnno, itype="l", ilwd=4, paletteName="Spectral",
add=TRUE)
  }



