### Name: peakDetectionCWT
### Title: The main function of peak detection by CWT based pattern
###   matching
### Aliases: peakDetectionCWT
### Keywords: methods

### ** Examples

        data(exampleMS)
        SNR.Th <- 3
        peakInfo <- peakDetectionCWT(exampleMS, SNR.Th=SNR.Th)
        majorPeakInfo = peakInfo$majorPeakInfo
        peakIndex <- majorPeakInfo$peakIndex
        plotPeak(exampleMS, peakIndex, main=paste('Identified peaks with SNR >', SNR.Th)) 
        
        ## In some cases, users may want to add peak filtering based on the absolute peak amplitude
        peakInfo <- peakDetectionCWT(exampleMS, SNR.Th=SNR.Th, peakThr=500)
        majorPeakInfo = peakInfo$majorPeakInfo
        peakIndex <- majorPeakInfo$peakIndex
        plotPeak(exampleMS, peakIndex, main=paste('Identified peaks with SNR >', SNR.Th))       



