### Name: import
### Title: Import raw file to an arrayCGH object
### Aliases: import import.default.aux import.gpr.aux import.spot.aux
### Keywords: IO file

### ** Examples

dir.in <- system.file("data", package="MANOR")

## import from 'spot' files
spot.names <- c("LogRatio", "RefFore", "RefBack", "DapiFore", "DapiBack", "SpotFlag", "ScaledLogRatio")
clone.names <- c("PosOrder", "Chromosome")
edge <- import(paste(dir.in, "/edge.txt", sep=""), type="spot",
spot.names=spot.names, clone.names=clone.names, add.lines=TRUE) 

## import from 'gpr' files
spot.names <- c("Clone", "FLAG", "TEST_B_MEAN", "REF_B_MEAN",
"TEST_F_MEAN", "REF_F_MEAN", "ChromosomeArm")  
clone.names <- c("Clone", "Chromosome", "Position", "Validation")
  
ac <- import(paste(dir.in, "/gradient.gpr", sep=""), type="gpr",
spot.names=spot.names, clone.names=clone.names, sep="\t", 
comment.char="@", add.lines=TRUE) 



