### Name: flag.summary
### Title: Summarize information about flags after array normalization
### Aliases: flag.summary flag.summary.arrayCGH flag.summary.default
### Keywords: misc

### ** Examples

data(spatial)
data(flags)
flag.list <- list(spatial=local.spatial.flag, spot=spot.corr.flag,
ref.snr=ref.snr.flag, dapi.snr=dapi.snr.flag, rep=rep.flag,
unique=unique.flag) 
flag.list$spatial$args <- alist(var="ScaledLogRatio", by.var=NULL,
nk=5, prop=0.25, thr=0.15, beta=1, family="symmetric") 
flag.list$spot$args <- alist(var="SpotFlag")
flag.list$spot$char <- "O"
flag.list$spot$label <- "Image analysis"

## normalize arrayCGH
## Not run: 
##D edge.norm <- norm(edge, flag.list=flag.list,
##D var="LogRatio", FUN=median, na.rm=TRUE)
## End(Not run) 
fs <- flag.summary(edge.norm, flag.list=flag.list, flag.var="Flag")

print("Flag and normalization parameters summary")
print(fs)



