###################################################
### chunk number 1:  eval=FALSE
###################################################
## packageDescription("LPE")


###################################################
### chunk number 2: 
###################################################
set.seed(0) 


###################################################
### chunk number 3: 
###################################################
library(LPE) 


###################################################
### chunk number 4: 
###################################################
data(Ley)
dim(Ley)
head(Ley)
Ley.subset <- Ley[seq(1000),]


###################################################
### chunk number 5: 
###################################################
Ley.normalized <- Ley.subset
Ley.normalized[,2:7] <- preprocess(Ley.subset[,2:7], data.type = "MAS5")
Ley.normalized[1:3,]


###################################################
### chunk number 6: 
###################################################
Ley.final <- Ley.normalized[substring(Ley.normalized$ID,1,4) !="AFFX",] 
dim(Ley.final)
Ley.final[1:3,]


###################################################
### chunk number 7: 
###################################################
var.Naive <- baseOlig.error(Ley.final[,2:4],q=0.01)
dim(var.Naive)
var.Naive[1:3,]


###################################################
### chunk number 8: 
###################################################
var.Activated <- baseOlig.error(Ley.final[,5:7], q=0.01)
dim(var.Activated)
var.Activated[1:3,]


###################################################
### chunk number 9: 
###################################################
lpe.val <- data.frame(lpe(Ley.final[,5:7], Ley.final[,2:4], 
                          var.Activated, var.Naive,
                          probe.set.name=Ley.final$ID)
                      )

lpe.val <- round(lpe.val, digits=2)
dim (lpe.val)
lpe.val[1:3,]


###################################################
### chunk number 10: 
###################################################
fdr.BH <- fdr.adjust(lpe.val, adjp="BH")
dim(fdr.BH)
round(fdr.BH[1:4, ],2)


###################################################
### chunk number 11: 
###################################################
fdr.resamp <- fdr.adjust(lpe.val, adjp="resamp", iterations=2)
fdr.resamp


###################################################
### chunk number 12: 
###################################################
Bonferroni.adjp <- fdr.adjust(lpe.val, adjp="Bonferroni")
head(Bonferroni.adjp)


