###################################################
### chunk number 1: options
###################################################
options(width=60)


###################################################
### chunk number 2: initialize
###################################################
library(IRanges)


###################################################
### chunk number 3: Rle-construction
###################################################
set.seed(0)
lambda <- c(rep(0.001, 4500), seq(0.001, 10, length = 500), seq(10,0.001, length = 500))
x <- Rle(rpois(1e7, lambda))
y <- Rle(rpois(1e7, lambda[c(251:length(lambda), 1:250)]))
x
y


###################################################
### chunk number 4: Rle-accessors
###################################################
head(runValue(x))
head(runLength(x))


###################################################
### chunk number 5: Rle-ops
###################################################
x > 0
x + y
x > 0 | y > 0


###################################################
### chunk number 6: Rle-summary
###################################################
range(x)
sum(x > 0 | y > 0)


###################################################
### chunk number 7: Rle-math
###################################################
log1p(x)


###################################################
### chunk number 8: Rle-cor
###################################################
cor(x, y)
shiftApply(249:251, y, x, FUN = function(x, y) var(x, y) / (sd(x) * sd(y)))


###################################################
### chunk number 9: sessionInfo
###################################################
toLatex(sessionInfo())


