### Name: Views-utils
### Title: Utility functions and numeric summary of Views of numerics
### Aliases: Views-utils slice slice,integer-method slice,Rle-method
###   slice,XInteger-method slice,XRleInteger-method viewApply
###   viewApply,Views-method viewApply,RleViews-method viewMins
###   viewMins,RleViews-method viewMins,XIntegerViews-method
###   viewMins,XRleIntegerViews-method viewMaxs viewMaxs,RleViews-method
###   viewMaxs,XIntegerViews-method viewMaxs,XRleIntegerViews-method
###   viewSums viewSums,RleViews-method viewSums,XIntegerViews-method
###   viewSums,XRleIntegerViews-method viewWhichMins
###   viewWhichMins,RleViews-method viewWhichMins,XIntegerViews-method
###   viewWhichMins,XRleIntegerViews-method viewWhichMaxs
###   viewWhichMaxs,RleViews-method viewWhichMaxs,XIntegerViews-method
###   viewWhichMaxs,XRleIntegerViews-method viewRangeMins
###   viewRangeMins,RleViews-method viewRangeMaxs
###   viewRangeMaxs,RleViews-method
### Keywords: methods algebra arith

### ** Examples

  ## Views derived from vector
  vec <- as.integer(c(19, 5, 0, 8, 5))
  slice(vec, lower=5, upper=8)

  set.seed(0)
  vec <- sample(24)
  vecViews <- slice(vec, lower=4, upper=16)
  vecViews
  viewApply(vecViews, function(x) diff(as.integer(x)))
  viewMins(vecViews)
  viewMaxs(vecViews)
  viewSums(vecViews)
  viewWhichMins(vecViews)
  viewWhichMaxs(vecViews)

  ## Views derived from coverage
  x <- IRanges(start=c(1L, 9L, 4L, 1L, 5L, 10L),
               width=c(5L, 6L, 3L, 4L, 3L,  3L))
  slice(coverage(x), lower=2)



