### Name: Rle-class
### Title: Rle objects
### Aliases: class:Rle Rle-class Rle Rle,missing,missing-method
###   Rle,vectorORfactor,missing-method Rle,vectorORfactor,integer-method
###   Rle,vectorORfactor,numeric-method runLength runLength,Rle-method
###   runValue runValue,Rle-method nrun nrun,Rle-method start,Rle-method
###   end,Rle-method width,Rle-method runLength<- runLength<-,Rle-method
###   runValue<- runValue<-,Rle-method as.vector,Rle,missing-method
###   as.logical,Rle-method as.integer,Rle-method as.numeric,Rle-method
###   as.complex,Rle-method as.character,Rle-method as.raw,Rle-method
###   as.factor,Rle-method coerce,vector,Rle-method
###   coerce,factor,Rle-method coerce,Rle,vector-method
###   coerce,Rle,logical-method coerce,Rle,integer-method
###   coerce,Rle,numeric-method coerce,Rle,complex-method
###   coerce,Rle,character-method coerce,Rle,raw-method
###   coerce,Rle,factor-method coerce,Rle,IRanges-method
###   coerce,Rle,NormalIRanges-method Ops,Rle,Rle-method
###   Ops,Rle,vector-method Ops,vector,Rle-method Math,Rle-method
###   Math2,Rle-method Summary,Rle-method Complex,Rle-method [,Rle-method
###   %in%,Rle,ANY-method aggregate,Rle-method c,Rle-method findRange
###   findRange,Rle-method findRun findRun,Rle-method head,Rle-method
###   is.na,Rle-method length,Rle-method rep,Rle-method rep.int
###   rep.int,Rle-method rev,Rle-method shiftApply
###   shiftApply,Rle,Rle-method show,Rle-method sort,Rle-method
###   subseq,Rle-method summary,Rle-method table table,Rle-method
###   tail,Rle-method unique,Rle-method window,Rle-method !,Rle-method
###   which,Rle-method pmax pmax,Rle-method pmin pmin,Rle-method pmax.int
###   pmax.int,Rle-method pmin.int pmin.int,Rle-method diff,Rle-method
###   mean,Rle-method var,Rle,missing-method var,Rle,Rle-method
###   cov,Rle,Rle-method cor,Rle,Rle-method sd,Rle-method median,Rle-method
###   quantile,Rle-method mad,Rle-method nchar,Rle-method substr,Rle-method
###   substring,Rle-method chartr,ANY,ANY,Rle-method tolower,Rle-method
###   toupper,Rle-method sub,ANY,ANY,Rle-method gsub,ANY,ANY,Rle-method
### Keywords: methods classes

### ** Examples

  x <- Rle(10:1, 1:10)
  x

  runLength(x)
  runValue(x)
  nrun(x)

  diff(x)
  unique(x)
  sort(x)
  sqrt(x)
  x^2 + 2 * x + 1
  x[c(1,3,5,7,9)]
  subseq(x, 4, 14)
  range(x)
  table(x)
  sum(x)
  mean(x)
  x > 4
  aggregate(x, x > 4, mean)
  aggregate(x, FUN = mean, start = 1:(length(x) - 50), end = 51:length(x))

  y <- Rle(c(TRUE,TRUE,FALSE,FALSE,TRUE,FALSE,TRUE,TRUE,TRUE))
  y
  as.vector(y)
  rep(y, 10)
  c(y, x > 5)

  z <- c("the", "quick", "red", "fox", "jumps", "over", "the", "lazy", "brown", "dog")
  z <- Rle(z, seq_len(length(z)))
  chartr("a", "@", z)
  toupper(z)



