### Name: IRanges-utils
### Title: IRanges utility functions
### Aliases: IRanges-utils successiveIRanges whichAsIRanges shift
###   shift,IRanges-method restrict restrict,IRanges-method narrow
###   narrow,IRanges-method narrow,NormalIRanges-method threebands
###   threebands,IRanges-method reduce reduce,IRanges-method gaps
###   gaps,IRanges-method reflect reflect,Ranges-method flank
###   flank,Ranges-method range,Ranges-method *,Ranges,numeric-method
###   asNormalIRanges coerce,IRanges,NormalIRanges-method intToRanges
###   intToAdjacentRanges toNormalIRanges
### Keywords: utilities

### ** Examples

  vec <- as.integer(c(19, 5, 0, 8, 5))
  whichAsIRanges(vec >= 5)
  x <- successiveIRanges(vec)
  x
  shift(x, -3)
  restrict(x, start=12, end=34)
  restrict(x, start=20)
  restrict(x, start=21)
  restrict(x, start=21, keep.all.ranges=TRUE)

  y <- x[width(x) != 0]
  narrow(y, start=4, end=-2)
  narrow(y, start=-4, end=-2)
  narrow(y, end=5, width=3)
  narrow(y, start = c(3, 4, 2, 3), end = c(12, 5, 7, 4))

  z <- threebands(y, start=4, end=-2)
  y0 <- punion(z$left, z$right, fill.gap=TRUE)
  identical(y, y0)  # TRUE
  threebands(y, start=-5)

  x <- IRanges(start=c(-2L, 6L, 9L, -4L, 1L, 0L, -6L, 10L),
               width=c( 5L, 0L, 6L,  1L, 4L, 3L,  2L,  3L))
  reduce(x)
  gaps(x)
  gaps(x, start=-6, end=20)  # Regions of the -6:20 range that are not masked by 'x'.

  ir1 <- IRanges(c(2,5,1), c(3,7,3))

  bounds <- IRanges(c(0, 5, 3), c(10, 6, 9))
  reflect(ir1, bounds)

  flank(ir1, 2)
  flank(ir1, 2, FALSE)
  flank(ir1, 2, c(FALSE, TRUE, FALSE))
  flank(ir1, c(2, -2, 2))
  flank(ir1, 2, both = TRUE)
  flank(ir1, 2, FALSE, TRUE)
  flank(ir1, -2, FALSE, TRUE)

  asNormalIRanges(x)   # 3 ranges ordered from left to right and separated by
                       # gaps of width >= 1.

  ## More on normality:
  example(`IRanges-class`)
  isNormal(x16)                        # FALSE
  if (interactive())
      x16 <- asNormalIRanges(x16)      # Error!
  whichFirstNotNormal(x16)             # 57
  isNormal(x16[1:56])                  # TRUE
  xx <- asNormalIRanges(x16[1:56])
  class(xx)
  max(xx)
  min(xx)



