plot.LD             package:GeneticsBase             R Documentation

_T_e_x_t_u_a_l _a_n_d _g_r_a_p_h_i_c_a_l _d_i_s_p_l_a_y _o_f _l_i_n_k_a_g_e _d_i_s_e_q_u_i_l_i_b_r_i_u_m (_L_D) _o_b_j_e_c_t_s

_D_e_s_c_r_i_p_t_i_o_n:

     Textual and graphical display of linkage disequilibrium (LD)
     objects

_U_s_a_g_e:

     plot(x, y, ...)
     plot.LD (x, y=NULL, cex, ...)
     LDView(LdMat,
            SNPloc=NULL,
            is.triangle=TRUE,
            SNPnames=NULL,
            cexSNPnames=0.2+1/log10(nrow(LdMat)),
            margins=c(6,2,3,6),
            main=NULL,
            barCol=rainbow(256,start=0,end=1/6 ),
            widths=c(10,10),
            heights=c(1,10),
            ...)

_A_r_g_u_m_e_n_t_s:

       x: LD or LDband object

       y: currently ignored

     cex: Scaling factor for table text. If absent, text will be scaled
          to fit within the table cells.

   LdMat: matrix of pair-wise LD measures

  SNPloc: SNP locations

is.triangle: indicate if 'LdMat' is a lower triangle matrix or not. if
          'LdMat' is an upper triangle, then the user has to transpose
          it before calling the function 'LDView'.

SNPnames: labels for SNPs

cexSNPnames: font size for SNPs labels

 margins: margins for heatmap

    main: title for the plot

  barCol: specify the color scheme

  widths: The plot is split into two parts - upper part and lower part
          'widths' specifies the widths of the two parts

 heights: The plot is split into two parts - upper part and lower part
          'heights' specifies the heights of the two parts

     ...: Optional arguments ('plot.LD.data.frame' passes these to
          'LDtable' and 'LDplot') and other parameters for the function
          'image'

_D_e_t_a_i_l_s:

     LDtable generates a graphical matrix of LD coefficients.  It
     attempts to properly set the font size so that the estimated
     values fit into the boxes.  It also colorized the boxes to whether
     the estimates are significantly different from no linkage.

     LDplot generates a plot of the LD coeffients across markers.  By
     default it will overlay plots for LD against all markers.  LD
     against a specific subset of markers can be obtained using the
     'marker' argument.

_V_a_l_u_e:

SNPnames: labels of the SNPs in 'LDView'

   LdMat: LD matrix

  SNPloc: SNP positions

_A_u_t_h_o_r(_s):

     Gregory R. Warnes warnes@bst.rochester.edu

_S_e_e _A_l_s_o:

     'LD', 'geneSet', 'diseq'

_E_x_a_m_p_l_e_s:

     # load the data
     data(CAMP)

     # compute pairwise LD
     ld <- LD(CAMP)

     print(ld)    # text display of LD coefficents and graphical display of LD estimates

     LDView(t(ld@"R^2"), SNPloc=1:8, SNPnames=CAMP@markerInfo$Name)

     ## LDtable(ld) # graphical display of LD estimates
     ## LDtable(ld, which="D'", digits=2) # graphical display of D' only 

     ## plot(CAMP) # two panel display

