haplo.score.slide.w       package:GeneticsBase       R Documentation

_W_r_a_p_p_e_r _f_o_r _h_a_p_l_o._s_c_o_r_e._s_l_i_d_e _i_n _h_a_p_l_o._s_t_a_t_s _p_a_c_k_a_g_e, _w_h_i_c_h _i_s _u_s_e_d _t_o _i_d_e_n_t_i_f_y _s_u_b-_h_a_p_l_o_t_y_p_e_s _f_r_o_m _a _g_r_o_u_p _o_f _l_o_c_i

_D_e_s_c_r_i_p_t_i_o_n:

     Wrapper for 'haplo.score.slide', which is used to identify
     sub-haplotypes from a group of loci.  Run haplo.score on all
     contiguous subsets of size n.slide from the loci in a genotype
     matrix (geno).  From each call to haplo.score, report the global
     score statistic p-value. Can also report global and maximum score
     statistics simulated p-values.

_U_s_a_g_e:

     haplo.score.slide.w(geneSetObj, 
                         trait.type = "gaussian", 
                         n.slide = 2, 
                         offset = NA, 
                         x.adj = NA, 
                         skip.haplo = 5/(2 * nrow(geno)), 
                         locus.label = NA, 
                         miss.val = c(0, NA), 
                         simulate = FALSE, 
                         sim.control = score.sim.control(), 
                         em.control = haplo.em.control())

_A_r_g_u_m_e_n_t_s:

geneSetObj: A geneSet object

trait.type: Character string defining type of trait, with values of
          gaussian, binomial, poisson, ordinal.

 n.slide: Number of loci in each contiguous subset.  The first subset
          is the ordered loci numbered 1 to n.slide, the second subset
          is 2 through 'n.slide'+1 and so on.  If the total number of
          loci in geno is 'n.loci', then there are 'n.loci' - 'n.slide'
          + 1 total subsets. 

  offset: Vector of offset when trait.type = poisson

   x.adj: Matrix of non-genetic covariates used to adjust the score
          statistics.  Note that intercept should not be included,  as
          it will be added in this function. 

skip.haplo: Skip score statistics for haplotypes with frequencies <
          'skip.haplo'. The default is for an expected count of 5 out
          of the 2*N haplotype  occurrences.

locus.label: Vector of labels for loci.

miss.val: Vector of values that represent missing alleles in geno.

simulate: Logical:  if [F]alse, no empirical p-values are computed; if
          [T]rue, simulations are performed. Specific simulation
          parameters can be controlled in the sim.control parameter
          list. 

sim.control: list of control parameters to determine how simulations
          are performed for simulated p-values. The list is created by
          the function 'score.sim.control' and the default values of
          this function can be changed as desired. See
          'score.sim.control' for details.

em.control: A list of control parameters to determine how to perform
          the EM algorithm for estimating haplotype frequencies when
          phase is   unknown. The list is created by the function
          'haplo.em.control' - see this function for more details

_D_e_t_a_i_l_s:

     Please refer to 'haplo.score.slide' for more details.

_V_a_l_u_e:

     List with the following components:

      df: Data frame with start locus, global p-value, simulated global
          p-value, and simulated maximum-score p-value. 

  n.loci: Number of loci given in the genotype matrix. 

simulate: Same as parameter description above. 

 n.slide: Same as parameter description above. 

locus.label: Same as parameter description above. 

n.val.haplo: Vector containing the number of valid simulations used in
          the maximum-score statistic p-value simulation.  The number
          of valid simulations can be less than the number of
          simulations requested (by sim.control) if simulated data sets
          produce unstable variables of the score statistics.  

n.val.global: Vector containing the number of valid simulations used in
          the global score statistic p-value simulation.   

_N_o_t_e:

     ~~further notes~~

_A_u_t_h_o_r(_s):

     Weiliang Qiu stwxq@channing.harvard.edu, Ross Lazarus
     ross.lazarus@channing.harvard.edu

_R_e_f_e_r_e_n_c_e_s:

     ~put references to the literature/web site here ~

_S_e_e _A_l_s_o:

     'haplo.em.w', 'haplo.scan.w', 'haplo.score.w'

_E_x_a_m_p_l_e_s:

     ##---- Should be DIRECTLY executable !! ----
     ##-- ==>  Define data, use random,
     ##--    or do  help(data=index)  for the standard data sets.

     ## The function is currently defined as
     "haplo.score.slide.w"

