### Name: RecoveryScore
### Title: Stability measures for gene rankings
### Aliases: RecoveryScore
### Keywords: univar

### ** Examples

### Load toy gene expression data
data(toydata)
### class labels
yy <- toydata[1,]
### gene expression
xx <- toydata[-1,]
### get ranking 
ordT <- RankingTstat(xx, yy, type="unpaired")
### Generate Leave-One-Out
loo <- GenerateFoldMatrix(xx, yy, k=1)
### Repeat Ranking with t-statistic
loor_ordT <- GetRepeatRanking(ordT, loo)
### Compute Recovery Score
rs_ordT <- RecoveryScore(loor_ordT, method="BH")



