### Name: GeneSelector
### Title: Exclude genes from being candidates for differential expression
### Aliases: GeneSelector
### Keywords: univar

### ** Examples

## Load toy gene expression data
data(toydata)
### class labels
yy <- toydata[1,]
### gene expression
xx <- toydata[-1,]
### Get Rankings from five different statistics
ordinaryT <- RankingTstat(xx, yy, type="unpaired")
baldilongT <- RankingBaldiLong(xx, yy, type="unpaired")
samT <- RankingSam(xx, yy, type="unpaired")
wilc <- RankingWilcoxon(xx, yy, type="unpaired")
wilcebam <- RankingWilcEbam(xx, yy, type="unpaired")
### form a list
LL <- list(ordinaryT, baldilongT, samT, wilc, wilcebam)
### order statistics (assign importance)
ordstat <-  c(3,4,2,1,5)
### start GeneSelector, threshold set to rank 50
gk50 <- GeneSelector(LL, indstatistic=ordstat, maxrank=50)
### start GeneSelector, using adaptive threshold based on p-values,
### here using the multiple testing procedure of Hochberg
gkpval <- GeneSelector(LL, indstatistic=ordstat, threshold = "BH", maxpval=0.05)
### show results
show(gkpval)
str(gkpval)
toplist(gkpval)
### which genes have been selected ?
SelectedGenes(gkpval)
### relative distance plot
plot(gkpval, top=5)
### Detailed information about gene 4
GeneInfoScreen(gkpval, which=4)


