### Name: readImage
### Title: Image I/O
### Aliases: readImage writeImage


### ** Examples

   ## Reads and display images
   f = system.file("images", "lena-color.png", package="EBImage")
   x = readImage(f)
   if (interactive()) display(x)

   x = readImage(system.file("images", "nuclei.tif", package="EBImage"))
   if (interactive()) display(x)
   
   try({
     im = readImage("http://www.google.com/intl/en/images/logo.gif")
     if (interactive()) display(im)
   })

   ## Converts a TIFF file into JPEG
   f1 = system.file("images", "lena-color.png", package="EBImage")
   x1 = readImage(f1)
   f2 = paste(tempfile(), "jpeg", sep=".")
   writeImage(x1, f2)
   cat("Converted '", f1, "' into '", f2, "'.\n", sep='')



