comp.B                 package:DEDS                 R Documentation

_C_o_m_p_u_t_i_n_g _B-_s_t_a_t_i_s_t_i_c_s _f_o_r _D_i_f_f_e_r_e_n_t_i_a_l _E_x_p_r_e_s_s_i_o_n

_D_e_s_c_r_i_p_t_i_o_n:

     'comp.B' returns a function of one argument with bindings for 'L'
     and 'proportion'. This function accepts a microarray data matrix
     as its single argment, when evaluated, computes lod-odds of
     differential expression by emprical Bayes shrinkage of the
     standard error toward a common value. The lod-odds are sometimes
     called B statistics.

_U_s_a_g_e:

     comp.B(L = NULL, proportion = 0.01)

_A_r_g_u_m_e_n_t_s:

       L: A vector of integers corresponding to observation (column)
          class labels. For k classes, the labels must be integers
          between 0 and k-1.

proportion: A numeric variable specifying the proportion of
          differential expression.

_D_e_t_a_i_l_s:

     The function returned by 'comp.B' calculates B statistics for each
     row of the microarray data matrix, with bindings for 'L' and
     'proportion'. It interfaces to a C function. 'comp.stat' is
     another function that wrapps around the same C function that could
     be used for computing B statistics (see examples below).

_V_a_l_u_e:

     'comp.B' returns a function (F) with the bindings for 'L' and
     'proportion' . The function F when supplied with a microarray data
     matrix and evaluated will return a numeric vector of B  statistics
     for each row of the matrix.

_A_u_t_h_o_r(_s):

     Yuanyuan Xiao, yxiao@itsa.ucsf.edu, 
      Jean Yee Hwa Yang, jeany@maths.usyd.edu.au.

_R_e_f_e_r_e_n_c_e_s:

     Lonnstedt, I. and Speed, T. P. (2002). Replicated microarray data.
     _Statistica Sinica_ 12, 31-46.

     Smyth, G. K. (2003). Linear models and empirical Bayes methods for
     assessing differential expression in microarray experiments.
     http://www.statsci.org/smyth/pubs/ebayes.pdf

_S_e_e _A_l_s_o:

     'comp.modt','comp.stat'.

_E_x_a_m_p_l_e_s:

     X <- matrix(rnorm(1000,0,0.5), nc=10)
     L <- rep(0:1,c(5,5))

     # genes 1-10 are differentially expressed
     X[1:10,6:10]<-X[1:10,6:10]+1

     # compute B statistics, proportion set as 0.01
     B.fun <- comp.B(L)
     B.X <- B.fun(X)

     # compute B statistics, proportion set as 0.1
     B.fun <- comp.B(L, proportion=0.1)
     B.X <- B.fun(X)

     # Another way of computing B statistics
     B.X<- comp.stat(X, L, "B")

