###################################################
### chunk number 1: lkc
###################################################
library(encoDnaseI)
data(rawCD4)
rawCD4


###################################################
### chunk number 2: lkd
###################################################
c19 = rawCD4[ chrnum(19) ]
c19


###################################################
### chunk number 3: lklk
###################################################
c19xy = getTrkXY(c19)
plot(c19xy)


###################################################
### chunk number 4: doinf
###################################################
clipSnps = function( rexset, chrmeta, lo, hi ) {
 allp = pos(chrmeta)
 ok = allp >= lo & allp <= hi
 rid = names(allp[ok])
 rexset[ snpID(rid), ]
}

rangeX = function(htrk) {
 range(getTrkXY(htrk)$x)
}


###################################################
### chunk number 5: dogg
###################################################
library(GGtools)
library(GGdata)
data(chr19GGceuRMA)
data(chr19meta)
rs19 = rangeX(c19)
c19f = clipSnps( chr19GGceuRMA, chr19meta, rs19[1], rs19[2] )
c19f


###################################################
### chunk number 6: lkmxi1
###################################################
smxi1 = snpScreen(c19f, chr19meta, genesym("MXI1"), ~., fastAGMfitter )
plot_mlp(smxi1, chr19meta, "10")


###################################################
### chunk number 7: doj
###################################################
#juxtaPlot = function( trk, ssr ) {
# sy = abs(ssr$trat)
# sx = ssr@locs
# txy = getTrkXY( trk )
# df = data.frame( y = sy, x = sx, type="absT" )
# df = rbind(df, data.frame(y = txy$y, x = txy$x, type = "dnaseI"))
# df$type = factor(df$type, levels=c("dnaseI", "absT"))
# require(lattice)
# xyplot( y~x| type, data=df, layout=c(1,2), 
#    scales=list(relation=list(y="free")))
#}
print(juxtaPlot( c19, smxi1 ))


###################################################
### chunk number 8: donex
###################################################
sOSR2 = snpScreen(c19f, chr19meta, genesym("OSR2"), ~., fastAGMfitter )
print(juxtaPlot( c19, sOSR2 ))


###################################################
### chunk number 9: dow
###################################################
ALICOR( sOSR2, c19 )
ALICOR( smxi1, c19 )


###################################################
### chunk number 10: donsf
###################################################
if (interactive()) {
if (!exists("mads")) mads = apply(exprs(c19f), 1, mad)
if (interactive()) fn = featureNames(c19f)[ which(mads > quantile(mads, .6)) ]
if (!interactive()) fn = featureNames(c19f)[ which(mads > quantile(mads, .97)) ]
n19 = c19f[ exFeatID(fn), ]
if (file.exists("tw19.rda")) load("tw19.rda")
if (!exists("tw19")) tw19 = twSnpScreen( n19, chr19meta, ~., fastAGMfitter)
if (!file.exists("tw19.rda")) save(tw19, file="tw19.rda")
if (file.exists("allscor.rda")) load("allscor.rda")
if (!exists("allscor")) allscor = sapply(tw19, function(x) {if (inherits(x, "try-error")) return(NA) else return(ALICOR(x, c19))})
if (!file.exists("allscor.rda")) save(allscor, file="allscor.rda")
}



