### Name: hg18track-class
### Title: Class "hg18track" container for hg18 annotation found in genome
###   browser track files; class "chrnum" extends numeric for an indexing
###   application on hg18track objects.
### Aliases: hg18track-class chrnum-class [,hg18track-method
###   chrnum,numeric-method chrnum,hg18track-method chrnum rangeLocs
###   chromStarts chromStarts,hg18track-method dataVals,hg18track-method
###   rangeLocs,hg18track-method getTrkXY dataVals
###   getTrkXY,hg18track,character-method getTrkXY,hg18track,missing-method
###   initialize,hg18track-method demoTrk19 clip
###   clip,hg18track,numeric,numeric,ANY-method makeHg18track
### Keywords: classes

### ** Examples

showClass("hg18track")
data(rawCD4)
rawCD4
rawCD4.chr1 = rawCD4[ chrnum(1), ]
rangeLocs(rawCD4.chr1)
plot(getTrkXY(rawCD4.chr1), ylab="data value", xlab="interval midpt on chr 1" )
c52 = clip(rawCD4[ chrnum(5), ], 1.30e8, 1.33e8 )
plot(getTrkXY(c52))



