/*
 * Decompiled with CFR 0.152.
 */
package de.proteinms.xtandemparser.xtandem;

import de.proteinms.xtandemparser.xtandem.Domain;
import de.proteinms.xtandemparser.xtandem.Peptide;
import de.proteinms.xtandemparser.xtandem.ProteinMap;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;

public class PeptideMap
implements Serializable {
    private HashMap<String, HashMap<String, Peptide>> iSpectrumAndPeptideMap = null;

    public PeptideMap(HashMap aRawPeptideMap, ProteinMap aProteinMap, int aNumberOfSpectra) {
        this.buildPeptideMap(aRawPeptideMap, aProteinMap, aNumberOfSpectra);
    }

    private HashMap buildPeptideMap(HashMap aRawPeptideMap, ProteinMap aProteinMap, int aNumberOfSpectra) {
        this.iSpectrumAndPeptideMap = new HashMap(aNumberOfSpectra);
        if (aRawPeptideMap != null) {
            for (int i = 1; i <= aNumberOfSpectra; ++i) {
                HashMap<String, Peptide> lPeptideMap = new HashMap<String, Peptide>();
                int pCount = 1;
                while (aRawPeptideMap.get("s" + i + "_p" + pCount) != null) {
                    String peptideID = "s" + i + "_p" + pCount;
                    int peptideStart = 0;
                    int peptideEnd = 0;
                    Object input = aRawPeptideMap.get("start_s" + i + "_p" + pCount);
                    if (input != null) {
                        peptideStart = new Integer(input.toString());
                    }
                    if ((input = aRawPeptideMap.get("start_s" + i + "_p" + pCount)) != null) {
                        peptideEnd = new Integer(input.toString());
                    }
                    input = aRawPeptideMap.get("seq_s" + i + "_p" + pCount);
                    String sequence = "";
                    if (input != null) {
                        sequence = aRawPeptideMap.get("seq_s" + i + "_p" + pCount).toString().trim();
                    }
                    Peptide peptide = new Peptide(peptideID, peptideStart, peptideEnd, sequence);
                    peptide.setSpectrumNumber(i);
                    if (aRawPeptideMap.get("URL_s" + i + "_p" + pCount) != null) {
                        peptide.setFastaFilePath(aRawPeptideMap.get("URL_s" + i + "_p" + pCount).toString());
                    }
                    int dCount = 1;
                    ArrayList<Domain> domainList = new ArrayList<Domain>();
                    while (aRawPeptideMap.get("domainid_s" + i + "_p" + pCount + "_d" + dCount) != null) {
                        Domain domain = new Domain();
                        String domainKey = "s" + i + "_p" + pCount + "_d" + dCount;
                        domain.setDomainKey(domainKey);
                        domain.setDomainID(aRawPeptideMap.get("domainid_s" + i + "_p" + pCount + "_d" + dCount).toString());
                        input = aRawPeptideMap.get("proteinkey_s" + i + "_p" + pCount + "_d" + dCount);
                        if (input != null) {
                            domain.setProteinKey(input.toString());
                        }
                        if ((input = aRawPeptideMap.get("domainstart_s" + i + "_p" + pCount + "_d" + dCount)) != null) {
                            domain.setDomainStart(Integer.parseInt(input.toString()));
                        }
                        if ((input = aRawPeptideMap.get("domainend_s" + i + "_p" + pCount + "_d" + dCount)) != null) {
                            domain.setDomainEnd(Integer.parseInt(input.toString()));
                        }
                        if ((input = aRawPeptideMap.get("expect_s" + i + "_p" + pCount + "_d" + dCount)) != null) {
                            domain.setDomainExpect(Double.parseDouble(input.toString()));
                        }
                        if ((input = aRawPeptideMap.get("mh_s" + i + "_p" + pCount + "_d" + dCount)) != null) {
                            domain.setDomainMh(Double.parseDouble(input.toString()));
                        }
                        if ((input = aRawPeptideMap.get("delta_s" + i + "_p" + pCount + "_d" + dCount)) != null) {
                            domain.setDomainDeltaMh(Double.parseDouble(input.toString()));
                        }
                        if ((input = aRawPeptideMap.get("hyperscore_s" + i + "_p" + pCount + "_d" + dCount)) != null) {
                            domain.setDomainHyperScore(Double.parseDouble(input.toString()));
                        }
                        if ((input = aRawPeptideMap.get("nextscore_s" + i + "_p" + pCount + "_d" + dCount)) != null) {
                            domain.setDomainNextScore(Double.parseDouble(input.toString()));
                        }
                        if ((input = aRawPeptideMap.get("pre_s" + i + "_p" + pCount + "_d" + dCount)) != null) {
                            domain.setUpFlankSequence(input.toString());
                        }
                        if ((input = aRawPeptideMap.get("post_s" + i + "_p" + pCount + "_d" + dCount)) != null) {
                            domain.setDownFlankSequence(input.toString());
                        }
                        if ((input = aRawPeptideMap.get("domainseq_s" + i + "_p" + pCount + "_d" + dCount)) != null) {
                            domain.setDomainSequence(input.toString());
                        }
                        if ((input = aRawPeptideMap.get("missed_cleavages_s" + i + "_p" + pCount + "_d" + dCount)) != null) {
                            domain.setMissedCleavages(Integer.parseInt(input.toString()));
                        }
                        domainList.add(domain);
                        ++dCount;
                    }
                    peptide.setDomains(domainList);
                    lPeptideMap.put(peptideID, peptide);
                    ++pCount;
                }
                this.iSpectrumAndPeptideMap.put("s" + i, lPeptideMap);
            }
        }
        return this.iSpectrumAndPeptideMap;
    }

    public HashMap<String, HashMap<String, Peptide>> getSpectrumAndPeptideMap() {
        return this.iSpectrumAndPeptideMap;
    }

    public ArrayList<Peptide> getAllPeptides(int aSpectrumNumber) {
        ArrayList<Peptide> arrayList = new ArrayList<Peptide>();
        if (this.iSpectrumAndPeptideMap.get("s" + aSpectrumNumber) != null) {
            arrayList = new ArrayList<Peptide>(this.iSpectrumAndPeptideMap.get("s" + aSpectrumNumber).values());
        }
        return arrayList;
    }

    public Peptide getPeptideByIndex(int aSpectrumNumber, int index) {
        return this.iSpectrumAndPeptideMap.get("s" + aSpectrumNumber).get("s" + aSpectrumNumber + "_p" + index);
    }

    public int getNumberOfPeptides(int aSpectrumNumber) {
        return this.iSpectrumAndPeptideMap.get("s" + aSpectrumNumber).size();
    }
}

