### R code from vignette source 'procoil.Rnw'

###################################################
### code chunk number 1: LoadPackageToDetermineVersion
###################################################
options(width=65)
set.seed(0)
library(procoil)
procoilVersion <- packageDescription("procoil")$Version
procoilDateRaw <- packageDescription("procoil")$Date
procoilDateYear <- as.numeric(substr(procoilDateRaw, 1, 4))
procoilDateMonth <- as.numeric(substr(procoilDateRaw, 6, 7))
procoilDateDay <- as.numeric(substr(procoilDateRaw, 9, 10))
procoilDate <- paste(month.name[procoilDateMonth], " ",
                     procoilDateDay, ", ",
                     procoilDateYear, sep="")


###################################################
### code chunk number 2: InstallPrOCoil (eval = FALSE)
###################################################
## source("http://www.bioconductor.org/biocLite.R")
## biocLite("procoil")


###################################################
### code chunk number 3: LoadPrOCoil (eval = FALSE)
###################################################
## library(procoil)


###################################################
### code chunk number 4: PredictGCN4WildType
###################################################
GCN4wt <- predict(PrOCoilModel, "MKQLEDKVEELLSKNYHLENEVARLKKLV", "abcdefgabcdefgabcdefgabcdefga")


###################################################
### code chunk number 5: PredictGCN4WildType2
###################################################
GCN4wt <- predict(PrOCoilModel, reg="abcdefgabcdefgabcdefgabcdefga",
                  seq="MKQLEDKVEELLSKNYHLENEVARLKKLV")


###################################################
### code chunk number 6: DisplayResultForGCN4WildType
###################################################
GCN4wt


###################################################
### code chunk number 7: PlotResultForGCN4WildType
###################################################
plot(GCN4wt)


###################################################
### code chunk number 8: PredictMarcoilExample
###################################################
res <- predict(PrOCoilModel,
"MGECDQLLVFMITSRVLVLSTLIIMDSRQVYLENLRQFAENLRQNIENVHSFLENLRADLENLRQKFPGKWYSAMPGRHG",
"-------------------------------abcdefgabcdefgabcdefgabcdefgabcdefg--------------")


###################################################
### code chunk number 9: DisplayResultForMarcoilExample
###################################################
res


###################################################
### code chunk number 10: PlotResultForMarcoilExample
###################################################
plot(res[[1]])


###################################################
### code chunk number 11: PredictGCN4Mutation
###################################################
GCN4m <- predict(PrOCoilModel, "MKQLEDKVEELLSKIYHNENEVARLKKLV", "abcdefgabcdefgabcdefgabcdefga")
GCN4m
plot(GCN4wt, GCN4m)


###################################################
### code chunk number 12: PlotResultForExampleWithHeptadIrregularity
###################################################
plot(predict(PrOCoilModel, "LQDTLVRQERPIRKSIEDLRNTV", "defgabcdefgabcdabcdefga"))


###################################################
### code chunk number 13: ReadModelFile (eval = FALSE)
###################################################
## readCCModel("http://www.bioinf.jku.at/software/procoil/PrOCoilModel.patternmodel")


###################################################
### code chunk number 14: ShowDefaultModel
###################################################
PrOCoilModel


###################################################
### code chunk number 15: CustomPlot
###################################################
plot(GCN4wt, GCN4m, legend=c("wild type", "mutant N16I,L19N"),
     col=c(rgb(0.7,0,0), rgb(0,0,0.8)), main="GCN4 Mutation Analysis",
     shades=c(rgb(0.77,0.85,0.95),rgb(0.99,0.84,0.71)))


###################################################
### code chunk number 16: PlotProfileToGraphicsFile (eval = FALSE)
###################################################
## pdf(file="GCN4wt.pdf",height=6,width=nchar(GCN4wt@seq)*6/24)
## plot(GCN4wt)
## dev.off()
## bmp(file="GCN4wt.bmp",height=480,width=nchar(GCN4wt@seq)*480/24)
## plot(GCN4wt)
## dev.off()


###################################################
### code chunk number 17: GCN4ExampleWithAttribute
###################################################
GCN4wtseq<-"MKQLEDKVEELLSKNYHLENEVARLKKLV"
attr(GCN4wtseq,"reg")<-"abcdefgabcdefgabcdefgabcdefga"
predict(PrOCoilModel,GCN4wtseq)


###################################################
### code chunk number 18: GCN4ExampleUsingBiostringWithAttribute
###################################################
require(Biostrings)
GCN4wtseq2<-AAString("MKQLEDKVEELLSKNYHLENEVARLKKLV")
attr(GCN4wtseq2,"reg")<-"abcdefgabcdefgabcdefgabcdefga"
predict(PrOCoilModel,GCN4wtseq2)


###################################################
### code chunk number 19: GCN4ExampleUsingBiostringWithMetaData
###################################################
GCN4wtseq3<-AAString("MKQLEDKVEELLSKNYHLENEVARLKKLV")
GCN4wtseq3@metadata$reg<-"abcdefgabcdefgabcdefgabcdefga"
predict(PrOCoilModel,GCN4wtseq3)


###################################################
### code chunk number 20: DisplayModels
###################################################
PrOCoilModel
weights(PrOCoilModel)["N..La"]
PrOCoilModelBA
weights(PrOCoilModelBA)["N..La"]


###################################################
### code chunk number 21: DisplayWeights
###################################################
noP<-length(weights(PrOCoilModel))
names(weights(PrOCoilModel))[1:25]
names(weights(PrOCoilModel))[noP:(noP-24)]


###################################################
### code chunk number 22: DisplayBibTeXReference (eval = FALSE)
###################################################
## toBibtex(citation("procoil"))


