### R code from vignette source 'geNetClassifier-vignette.Rnw'

###################################################
### code chunk number 1: geNetClassifier-vignette.Rnw:85-87 (eval = FALSE)
###################################################
## source("http://bioconductor.org/biocLite.R")
## biocLite("geNetClassifier")


###################################################
### code chunk number 2: geNetClassifier-vignette.Rnw:93-94 (eval = FALSE)
###################################################
## biocLite("leukemiasEset")


###################################################
### code chunk number 3: geNetClassifier-vignette.Rnw:100-103
###################################################
library(leukemiasEset)
data(leukemiasEset)
leukemiasEset


###################################################
### code chunk number 4: geNetClassifier-vignette.Rnw:105-106
###################################################
summary(leukemiasEset$LeukemiaType) 


###################################################
### code chunk number 5: geNetClassifier-vignette.Rnw:108-109 (eval = FALSE)
###################################################
## pData(leukemiasEset)


###################################################
### code chunk number 6: geNetClassifier-vignette.Rnw:112-113 (eval = FALSE)
###################################################
## ?leukemiasEset


###################################################
### code chunk number 7: geNetClassifier-vignette.Rnw:119-122 (eval = FALSE)
###################################################
## load("genes-human-annotation.R")
## geneSymbols <- genes.human.Annotation[,"gene_symbol",drop=F]
## head(geneSymbols)


###################################################
### code chunk number 8: geNetClassifier-vignette.Rnw:126-131 (eval = FALSE)
###################################################
## leukEset_protCoding <- leukemiasEset[featureNames(leukemiasEset) 
##  %in% rownames(genes.human.Annotation[genes.human.Annotation$biotype 
##  %in% "protein_coding",]),]
## dim(leukemiasEset)
## dim(leukEset_protCoding)


###################################################
### code chunk number 9: geNetClassifier-vignette.Rnw:157-158
###################################################
library(geNetClassifier)


###################################################
### code chunk number 10: geNetClassifier-vignette.Rnw:161-165 (eval = FALSE)
###################################################
## # List available vignettes for package geNetClassifier: 
## vignette(package="geNetClassifier")
## # Open vignette named "geNetClassifier-vignette":
## vignette("geNetClassifier-vignette")


###################################################
### code chunk number 11: geNetClassifier-vignette.Rnw:168-169
###################################################
options(width=80)


###################################################
### code chunk number 12: geNetClassifier-vignette.Rnw:171-172
###################################################
objects("package:geNetClassifier")


###################################################
### code chunk number 13: geNetClassifier-vignette.Rnw:174-175 (eval = FALSE)
###################################################
## ?geNetClassifier


###################################################
### code chunk number 14: geNetClassifier-vignette.Rnw:178-180 (eval = FALSE)
###################################################
## library(leukemiasEset)
## data(leukemiasEset)


###################################################
### code chunk number 15: geNetClassifier-vignette.Rnw:183-184 (eval = FALSE)
###################################################
## load(file="...")


###################################################
### code chunk number 16: geNetClassifier-vignette.Rnw:189-191
###################################################
trainSamples <- c(1:10, 13:22, 25:34, 37:46, 49:58)
summary(leukemiasEset$LeukemiaType[trainSamples])


###################################################
### code chunk number 17: geNetClassifier-vignette.Rnw:225-227 (eval = FALSE)
###################################################
## leukemiasClassifier <- geNetClassifier(eset=leukemiasEset[,trainSamples], 
## sampleLabels="LeukemiaType", plotsName="leukemiasClassifier") 


###################################################
### code chunk number 18: geNetClassifier-vignette.Rnw:230-233 (eval = FALSE)
###################################################
## leukemiasClassifier <- geNetClassifier(eset=leukemiasEset[,trainSamples], 
## sampleLabels="LeukemiaType", plotsName="leukemiasClassifier", 
## estimateGError=TRUE)


###################################################
### code chunk number 19: geNetClassifier-vignette.Rnw:236-239 (eval = FALSE)
###################################################
## leukemiasClassifier <- geNetClassifier(eset=leukemiasEset[,trainSamples], 
## sampleLabels="LeukemiaType", plotsName="leukemiasClassifier", 
## skipInteractions=TRUE, maxGenesTrain=20, geneLabels=geneSymbols)


###################################################
### code chunk number 20: geNetClassifier-vignette.Rnw:246-247 (eval = FALSE)
###################################################
## save(leukemiasClassifier, file="leukemiasClassifier.RData") 


###################################################
### code chunk number 21: geNetClassifier-vignette.Rnw:251-254 (eval = FALSE)
###################################################
## getwd()
## dir()
## load("leukemiasClassifier.RData")


###################################################
### code chunk number 22: geNetClassifier-vignette.Rnw:258-259
###################################################
data(leukemiasClassifier) 


###################################################
### code chunk number 23: geNetClassifier-vignette.Rnw:263-266 (eval = FALSE)
###################################################
## leukemiasClassifier <- geNetClassifier(leukEset_protCoding[,trainSamples],
## sampleLabels="LeukemiaType", plotsName="leukemiasClassifier",
##  estimateGError=TRUE, geneLabels=geneSymbols)


###################################################
### code chunk number 24: geNetClassifier-vignette.Rnw:274-275
###################################################
class(leukemiasClassifier)


###################################################
### code chunk number 25: geNetClassifier-vignette.Rnw:279-280
###################################################
options(width=50)


###################################################
### code chunk number 26: geNetClassifier-vignette.Rnw:282-283
###################################################
names(leukemiasClassifier)


###################################################
### code chunk number 27: geNetClassifier-vignette.Rnw:285-286
###################################################
options(width=80)


###################################################
### code chunk number 28: geNetClassifier-vignette.Rnw:291-292
###################################################
leukemiasClassifier@call


###################################################
### code chunk number 29: geNetClassifier-vignette.Rnw:296-297
###################################################
leukemiasClassifier


###################################################
### code chunk number 30: geNetClassifier-vignette.Rnw:311-312
###################################################
leukemiasClassifier@genesRanking


###################################################
### code chunk number 31: geNetClassifier-vignette.Rnw:316-317
###################################################
numGenes(leukemiasClassifier@genesRanking)


###################################################
### code chunk number 32: geNetClassifier-vignette.Rnw:321-322
###################################################
miniRanking <- getTopRanking(leukemiasClassifier@genesRanking, 6)


###################################################
### code chunk number 33: geNetClassifier-vignette.Rnw:326-327
###################################################
getRanking(miniRanking)


###################################################
### code chunk number 34: geNetClassifier-vignette.Rnw:330-331
###################################################
getRanking(miniRanking, showGeneID=TRUE)$geneID


###################################################
### code chunk number 35: geNetClassifier-vignette.Rnw:335-336
###################################################
genesDetails(miniRanking)$AML


###################################################
### code chunk number 36: geNetClassifier-vignette.Rnw:340-341 (eval = FALSE)
###################################################
## options(width=200)


###################################################
### code chunk number 37: geNetClassifier-vignette.Rnw:375-376
###################################################
numSignificantGenes(leukemiasClassifier@genesRanking)


###################################################
### code chunk number 38: geNetClassifier-vignette.Rnw:380-381 (eval = FALSE)
###################################################
## plot(leukemiasClassifier@genesRanking)


###################################################
### code chunk number 39: geNetClassifier-vignette.Rnw:385-387 (eval = FALSE)
###################################################
## plot(leukemiasClassifier@genesRanking, 
## numGenesPlot=3000, lpThreshold=0.80)


###################################################
### code chunk number 40: geNetClassifier-vignette.Rnw:399-400
###################################################
leukemiasClassifier@classifier


###################################################
### code chunk number 41: geNetClassifier-vignette.Rnw:404-405
###################################################
leukemiasClassifier@classificationGenes


###################################################
### code chunk number 42: geNetClassifier-vignette.Rnw:407-409
###################################################
numGenes(leukemiasClassifier@classificationGenes)
genesDetails(leukemiasClassifier@classificationGenes)$ALL


###################################################
### code chunk number 43: geNetClassifier-vignette.Rnw:468-469
###################################################
leukemiasClassifier@generalizationError


###################################################
### code chunk number 44: geNetClassifier-vignette.Rnw:472-473 (eval = FALSE)
###################################################
## overview(leukemiasClassifier@generalizationError)


###################################################
### code chunk number 45: geNetClassifier-vignette.Rnw:479-480
###################################################
leukemiasClassifier@generalizationError@confMatrix


###################################################
### code chunk number 46: geNetClassifier-vignette.Rnw:484-485
###################################################
leukemiasClassifier@generalizationError@probMatrix


###################################################
### code chunk number 47: geNetClassifier-vignette.Rnw:494-495
###################################################
leukemiasClassifier@generalizationError@classificationGenes.stats$CLL


###################################################
### code chunk number 48: geNetClassifier-vignette.Rnw:500-501
###################################################
leukemiasClassifier@generalizationError@classificationGenes.num


###################################################
### code chunk number 49: geNetClassifier-vignette.Rnw:515-517
###################################################
leukemiasClassifier@genesNetwork
overview(leukemiasClassifier@genesNetwork$AML)


###################################################
### code chunk number 50: geNetClassifier-vignette.Rnw:522-524
###################################################
getNumEdges(leukemiasClassifier@genesNetwork$AML)
getNumNodes(leukemiasClassifier@genesNetwork$AML)


###################################################
### code chunk number 51: geNetClassifier-vignette.Rnw:526-528
###################################################
getEdges(leukemiasClassifier@genesNetwork$AML)[1:5,]
getNodes(leukemiasClassifier@genesNetwork$AML)[1:12]


###################################################
### code chunk number 52: geNetClassifier-vignette.Rnw:532-533 (eval = FALSE)
###################################################
## network2txt(leukemiasClassifier@genesNetwork, filePrefix="leukemiasNetwork")


###################################################
### code chunk number 53: geNetClassifier-vignette.Rnw:536-539 (eval = FALSE)
###################################################
## geneNtwsInfo <- lapply(leukemiasClassifier@genesNetwork, 
## function(x) write.table(getEdges(x), 
## file=paste("leukemiaNtw_",getEdges(x)[1,"class1"],".txt",sep="")))


###################################################
### code chunk number 54: geNetClassifier-vignette.Rnw:552-554
###################################################
testSamples <- c(1:60)[-trainSamples]
testSamples


###################################################
### code chunk number 55: geNetClassifier-vignette.Rnw:558-560
###################################################
queryResult <- queryGeNetClassifier(leukemiasClassifier, 
leukemiasEset[,testSamples])


###################################################
### code chunk number 56: geNetClassifier-vignette.Rnw:564-566
###################################################
queryResult$class
queryResult$probabilities


###################################################
### code chunk number 57: geNetClassifier-vignette.Rnw:570-572
###################################################
confusionMatrix <- table(leukemiasEset[,testSamples]$LeukemiaType, 
queryResult$class)


###################################################
### code chunk number 58: geNetClassifier-vignette.Rnw:576-577
###################################################
externalValidation.stats(confusionMatrix)


###################################################
### code chunk number 59: geNetClassifier-vignette.Rnw:581-583
###################################################
externalValidation.probMatrix(queryResult, 
leukemiasEset[,testSamples]$LeukemiaType, numDecimals=3)


###################################################
### code chunk number 60: geNetClassifier-vignette.Rnw:595-598
###################################################
queryResult_AssignAll <- queryGeNetClassifier(leukemiasClassifier, 
leukemiasEset[,testSamples], minProbAssignCoeff=0, minDiffAssignCoeff=0)
which(queryResult_AssignAll$class=="NotAssigned")


###################################################
### code chunk number 61: geNetClassifier-vignette.Rnw:604-607
###################################################
queryResult_AssignLess <- queryGeNetClassifier(leukemiasClassifier, 
leukemiasEset[,testSamples], minProbAssignCoeff=1.5, minDiffAssignCoeff=1)
queryResult_AssignLess$class


###################################################
### code chunk number 62: geNetClassifier-vignette.Rnw:610-612
###################################################
t(queryResult_AssignLess$probabilities[,
queryResult_AssignLess$class=="NotAssigned", drop=FALSE])


###################################################
### code chunk number 63: geNetClassifier-vignette.Rnw:616-618
###################################################
confusionMatrix2 <- table(leukemiasEset[,testSamples]$LeukemiaType, 
queryResult_AssignLess$class)


###################################################
### code chunk number 64: geNetClassifier-vignette.Rnw:620-621
###################################################
externalValidation.stats(confusionMatrix2)


###################################################
### code chunk number 65: geNetClassifier-vignette.Rnw:642-643
###################################################
testSamples <- c(1:60)[-trainSamples]


###################################################
### code chunk number 66: geNetClassifier-vignette.Rnw:647-649
###################################################
queryResult_AsUnkown <- queryGeNetClassifier(leukemiasClassifier, 
leukemiasEset[,testSamples])


###################################################
### code chunk number 67: geNetClassifier-vignette.Rnw:653-654
###################################################
names(queryResult_AsUnkown)


###################################################
### code chunk number 68: geNetClassifier-vignette.Rnw:656-657
###################################################
queryResult_AsUnkown$class


###################################################
### code chunk number 69: geNetClassifier-vignette.Rnw:661-663
###################################################
t(queryResult_AsUnkown$probabilities[ ,
queryResult$class=="NotAssigned"])


###################################################
### code chunk number 70: geNetClassifier-vignette.Rnw:667-668
###################################################
querySummary(queryResult_AsUnkown, numDecimals=3)


###################################################
### code chunk number 71: geNetClassifier-vignette.Rnw:681-682 (eval = FALSE)
###################################################
## plot(leukemiasClassifier@genesRanking)


###################################################
### code chunk number 72: geNetClassifier-vignette.Rnw:687-689 (eval = FALSE)
###################################################
## plot(leukemiasClassifier@genesRanking, numGenesPlot=3000, 
## plotTitle="5 classes: ALL, AML, CLL, CML, NoL", lpThreshold=0.80)


###################################################
### code chunk number 73: geNetClassifier-vignette.Rnw:699-701 (eval = FALSE)
###################################################
## ranking <- calculateGenesRanking(leukemiasEset[,trainSamples], 
## "LeukemiaType")


###################################################
### code chunk number 74: geNetClassifier-vignette.Rnw:710-713 (eval = FALSE)
###################################################
## myGenes <- c("ENSG00000169575", "ENSG00000078399", 
## "ENSG00000176890", "ENSG00000121742")
## plotExpressionProfiles(leukemiasEset, myGenes, sampleLabels="LeukemiaType")


###################################################
### code chunk number 75: geNetClassifier-vignette.Rnw:723-725 (eval = FALSE)
###################################################
## plotExpressionProfiles(leukemiasEset[,trainSamples], leukemiasClassifier,
## sampleLabels="LeukemiaType", fileName="leukExprs_trainSamples.pdf")


###################################################
### code chunk number 76: geNetClassifier-vignette.Rnw:729-733 (eval = FALSE)
###################################################
## classGenes <- getRanking(leukemiasClassifier@classificationGenes, 
## showGeneID=TRUE)$geneID[,"AML"]
## plotExpressionProfiles(leukemiasEset, genes=classGenes, 
## sampleLabels="LeukemiaType", fileName="AML.pdf", geneLabels=geneSymbols)


###################################################
### code chunk number 77: geNetClassifier-vignette.Rnw:746-748
###################################################
plotDiscriminantPower(leukemiasClassifier, 
classificationGenes="ENSG00000169575")


###################################################
### code chunk number 78: geNetClassifier-vignette.Rnw:752-754
###################################################
plotDiscriminantPower(leukemiasClassifier, 
classificationGenes="ENSG00000169575")


###################################################
### code chunk number 79: geNetClassifier-vignette.Rnw:762-765 (eval = FALSE)
###################################################
## discPowerTable <- plotDiscriminantPower(leukemiasClassifier, 
## classificationGenes=getRanking(leukemiasClassifier@classificationGenes,
## showGeneID=T)$geneID[1:4,"AML",drop=FALSE], returnTable=TRUE)


###################################################
### code chunk number 80: geNetClassifier-vignette.Rnw:769-772
###################################################
discPowerTable <- plotDiscriminantPower(leukemiasClassifier, 
classificationGenes=getRanking(leukemiasClassifier@classificationGenes,
showGeneID=T)$geneID[1:4,"AML",drop=FALSE], returnTable=TRUE)


###################################################
### code chunk number 81: geNetClassifier-vignette.Rnw:787-789
###################################################
clGenesSubNet <- getSubNetwork(leukemiasClassifier@genesNetwork, 
leukemiasClassifier@classificationGenes)


###################################################
### code chunk number 82: geNetClassifier-vignette.Rnw:796-797 (eval = FALSE)
###################################################
## clGenesInfo <- genesDetails(leukemiasClassifier@classificationGenes)


###################################################
### code chunk number 83: geNetClassifier-vignette.Rnw:804-806 (eval = FALSE)
###################################################
## plotNetwork(genesNetwork=clGenesSubNet$ALL, genesInfo=clGenesInfo, 
## plotAllNodesNetwork=FALSE, plotOnlyConnectedNodesNetwork=TRUE)


###################################################
### code chunk number 84: geNetClassifier-vignette.Rnw:810-811 (eval = FALSE)
###################################################
## plotNetwork(genesNetwork=clGenesSubNet$ALL, genesInfo=clGenesInfo)


###################################################
### code chunk number 85: geNetClassifier-vignette.Rnw:822-828 (eval = FALSE)
###################################################
## top30g <- getRanking(leukemiasClassifier@genesRanking, 
## showGeneID=TRUE)$geneID[1:30,]
## top30gSubNet <- getSubNetwork(leukemiasClassifier@genesNetwork, top30g)
## top30gInfo <- lapply(genesDetails(leukemiasClassifier@genesRanking), 
## function(x) x[1:30,])
## plotNetwork(genesNetwork=top30gSubNet$AML, genesInfo=top30gInfo$AML)


###################################################
### code chunk number 86: geNetClassifier-vignette.Rnw:841-851 (eval = FALSE)
###################################################
## top100gRanking <- getTopRanking(leukemiasClassifier@genesRanking, 
## numGenes=100)
## top100gSubNet <- getSubNetwork(leukemiasClassifier@genesNetwork, 
## getRanking(top100gRanking, showGeneID=TRUE)$geneID)
## plotNetwork(genesNetwork=top100gSubNet, 
## classificationGenes=leukemiasClassifier@classificationGenes, 
## genesRanking=top100gRanking, plotAllNodesNetwork=TRUE, 
## plotOnlyConnectedNodesNetwork=TRUE, labelSize=0.4, 
## returniGraphs=FALSE, plotType="pdf", 
## fileName="leukemiasNetwork")


