### R code from vignette source 'asmn-vignette.Rnw'

###################################################
### code chunk number 1: "load"
###################################################
library(asmn)


###################################################
### code chunk number 2: "data"
###################################################
library("methylumi")
library("TCGAMethylation450k")
idatPath <- system.file('extdata/idat',package='TCGAMethylation450k')
mset450k <- methylumIDAT(getBarcodes(path=idatPath), idatPath=idatPath)
sampleNames(mset450k) <- paste0('TCGA', seq_along(sampleNames(mset450k)))
show(mset450k)


###################################################
### code chunk number 3: makenormfacs
###################################################
normfactors <- norm_factors(controldata=NULL, 
                            subjects=NULL, 
                            methylumidata=mset450k, 
                            type="methylumi")
str(normfactors)
normfactors


###################################################
### code chunk number 4: normalize
###################################################
featureData(mset450k)
str(fData(mset450k))
normdata <- normalize_asmn(normfactors = normfactors, 
                      rawdata=NULL, 
                      featuredata=NULL, 
                      methylumidata=mset450k, 
                      type="methylumi")
show(normdata)


###################################################
### code chunk number 5: coerce
###################################################
normdataM <- as(normdata, 'MethyLumiM')
show(normdataM)


