
## ----message=FALSE, results="asis"---------------------------------------
my.df <- data.frame(EGID = c("103", "104", "105", "106", "107"),
                    RPKM = c(4, 5, 3, 100, 75),
                    DE = c("Yes", "Yes", "No", "No", "No"))

library(ReportingTools)


## ----results="asis"------------------------------------------------------
library(XML)
instDoc <- file.path("..", "inst", "doc")
htmlRep <- HTMLReport(shortName = "knitrReport", handlers=knitrHandlers,
                      reportDirectory = instDoc)
#publish(my.df, htmlRep)
htmlRep[["mydf"]]<-my.df  ##this line is equivalent to the line above


## ----results = "asis"----------------------------------------------------
library(lattice)
set.seed(123)
htmlRep[["pic"]] = xyplot(y~x, data = data.frame(y=rnorm(25), x=rnorm(25)))
##We could also add a picture like this:
y <- rnorm(500)
pic2<-histogram(y, main="Sample of 500 observations from a Normal (0,1)")
publish(pic2, htmlRep)


