### R code from vignette source 'ExiMiR-vignette.Rnw'

###################################################
### code chunk number 1: ExiMiR-vignette.Rnw:693-695
###################################################
library(ExiMiR)
data(GSE19183)


###################################################
### code chunk number 2: ExiMiR-vignette.Rnw:698-704
###################################################
library(affy)
eset.rma <- expresso(GSE19183, bgcorrect.method='rma',
			       normalize.method='quantiles',
			       pmcorrect.method='pmonly',
			       summary.method='medianpolish')



###################################################
### code chunk number 3: ExiMiR-vignette.Rnw:707-712
###################################################
eset.spike <- NormiR(GSE19183, bgcorrect.method='rma',
			       normalize.method='spikein',
			       normalize.param=list(figures.show=FALSE),
			       pmcorrect.method='pmonly',
			       summary.method='medianpolish')


###################################################
### code chunk number 4: ExiMiR-vignette.Rnw:722-725
###################################################
library(ExiMiR)
data(galenv)
data(GSE20122)


###################################################
### code chunk number 5: ExiMiR-vignette.Rnw:729-732
###################################################
eset.rma <- NormiR(GSE20122, bg.correct=FALSE,
			     normalize.method='quantile',
			     summary.method='medianpolish')


###################################################
### code chunk number 6: ExiMiR-vignette.Rnw:735-739
###################################################
eset.spike <- NormiR(GSE20122, bg.correct=FALSE,
			       normalize.method='spikein',
			       normalize.param=list(figures.show=FALSE),
			       summary.method='medianpolish')


